/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.bundle;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jetty.util.component.LifeCycle;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.option.Option;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyCommonRegistration;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationShutdownListener;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationShutdownListenerAdapter;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationStartupListener;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationStartupListenerAdapter;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.GuiceyStartupListener;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.GuiceyStartupListenerAdapter;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class GuiceyEnvironment
implements GuiceyCommonRegistration<GuiceyEnvironment> {
    private final ConfigurationContext context;

    public GuiceyEnvironment(ConfigurationContext context) {
        this.context = context;
    }

    public <T extends Configuration> T configuration() {
        return (T)this.context.getConfiguration();
    }

    public <T> T configuration(String yamlPath) {
        return this.configurationTree().valueByPath(yamlPath);
    }

    public <T, K extends T> K configuration(Class<T> type) {
        return this.configurationTree().valueByUniqueDeclaredType(type);
    }

    public <T> List<? extends T> configurations(Class<T> type) {
        return this.configurationTree().valuesByType(type);
    }

    protected <T> T annotatedConfiguration(Annotation annotation) {
        return this.configurationTree().annotatedValue(annotation);
    }

    protected <T> T annotatedConfiguration(Class<? extends Annotation> qualifierType) {
        return this.configurationTree().annotatedValue(qualifierType);
    }

    public ConfigurationTree configurationTree() {
        return this.context.getConfigurationTree();
    }

    public Environment environment() {
        return this.context.getEnvironment();
    }

    public GuiceyEnvironment register(Object ... items) {
        for (Object item : items) {
            this.environment().jersey().register(item);
        }
        return this;
    }

    public GuiceyEnvironment register(Class<?> ... items) {
        for (Class<?> item : items) {
            this.environment().jersey().register(item);
        }
        return this;
    }

    public GuiceyEnvironment manage(Managed managed) {
        this.environment().lifecycle().manage(managed);
        return this;
    }

    public <C extends Configuration> GuiceyEnvironment onGuiceyStartup(GuiceyStartupListener<C> listener) {
        return this.listen(new GuiceyStartupListenerAdapter<C>(listener));
    }

    public GuiceyEnvironment onApplicationStartup(ApplicationStartupListener listener) {
        return this.listen(new ApplicationStartupListenerAdapter(listener));
    }

    public GuiceyEnvironment onApplicationShutdown(ApplicationShutdownListener listener) {
        return this.listen(new ApplicationShutdownListenerAdapter(listener));
    }

    public GuiceyEnvironment listenServer(ServerLifecycleListener listener) {
        this.environment().lifecycle().addServerLifecycleListener(listener);
        return this;
    }

    public GuiceyEnvironment listenJetty(LifeCycle.Listener listener) {
        this.environment().lifecycle().addEventListener(listener);
        return this;
    }

    public GuiceyEnvironment listenJersey(ApplicationEventListener listener) {
        this.environment().jersey().register((Object)listener);
        return this;
    }

    @Override
    public <K extends Configuration> Bootstrap<K> bootstrap() {
        return this.context.getBootstrap();
    }

    @Override
    public <K extends Configuration> Application<K> application() {
        return this.context.getBootstrap().getApplication();
    }

    @Override
    public <V, K extends Enum<? extends Option>> V option(K option) {
        return this.context.option(option);
    }

    @Override
    public GuiceyEnvironment modules(Module ... modules) {
        Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
        this.context.registerModules(modules);
        return this;
    }

    @Override
    public GuiceyEnvironment modulesOverride(Module ... modules) {
        this.context.registerModulesOverride(modules);
        return this;
    }

    @Override
    public GuiceyEnvironment extensions(Class<?> ... extensionClasses) {
        this.context.registerExtensions(extensionClasses);
        return this;
    }

    @Override
    public GuiceyEnvironment extensionsOptional(Class<?> ... extensionClasses) {
        this.context.registerExtensionsOptional(extensionClasses);
        return this;
    }

    @Override
    public GuiceyEnvironment disableExtensions(Class<?> ... extensions) {
        this.context.disableExtensions(extensions);
        return this;
    }

    @Override
    @SafeVarargs
    public final GuiceyEnvironment disableModules(Class<? extends Module> ... modules) {
        this.context.disableModules(modules);
        return this;
    }

    @Override
    public GuiceyEnvironment listen(GuiceyLifecycleListener ... listeners) {
        this.context.lifecycle().register(listeners);
        return this;
    }

    @Override
    public <K> GuiceyEnvironment shareState(Class<K> key, K value) {
        this.context.getSharedState().put(key, value);
        return this;
    }

    @Override
    public <K> K sharedState(Class<K> key, Supplier<K> defaultValue) {
        return this.context.getSharedState().get(key, defaultValue);
    }

    @Override
    public <K> Optional<K> sharedState(Class<K> key) {
        return Optional.ofNullable(this.context.getSharedState().get(key));
    }

    @Override
    public <K> K sharedStateOrFail(Class<K> key, String message, Object ... args) {
        return this.context.getSharedState().getOrFail(key, message, args);
    }

    @Override
    public <V> void whenSharedStateReady(Class<V> key, Consumer<V> action) {
        this.context.getSharedState().whenReady(key, action);
    }
}

