/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.dropwizard.core.setup.Bootstrap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.stat.DetailStat;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;

public final class BundleSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleSupport.class);

    private BundleSupport() {
    }

    public static void initBundles(ConfigurationContext context) {
        ArrayList<Class<? extends GuiceyBundle>> path = new ArrayList<Class<? extends GuiceyBundle>>();
        List<GuiceyBundle> bundles = context.getEnabledBundles();
        ArrayList<GuiceyBundle> initOrder = new ArrayList<GuiceyBundle>();
        GuiceyBootstrap guiceyBootstrap = new GuiceyBootstrap(context, path, initOrder);
        BundleSupport.initBundles(context, guiceyBootstrap, path, initOrder, bundles);
        context.storeBundlesInitOrder(initOrder);
        context.lifecycle().bundlesInitialized(new ArrayList<GuiceyBundle>(initOrder), context.getDisabledBundles(), context.getIgnoredItems(ConfigItem.Bundle));
    }

    public static void initBundles(ConfigurationContext context, GuiceyBootstrap bootstrap, List<Class<? extends GuiceyBundle>> path, List<GuiceyBundle> initOrder, List<GuiceyBundle> bundles) {
        for (GuiceyBundle bundle : bundles) {
            BundleSupport.initBundle(path, initOrder, bundle, context, bootstrap);
        }
    }

    public static void runBundles(ConfigurationContext context) throws Exception {
        GuiceyEnvironment env = new GuiceyEnvironment(context);
        context.processDelayedConfigurations(env);
        List<GuiceyBundle> bundlesOrdered = context.getBundlesOrdered();
        for (GuiceyBundle bundle : bundlesOrdered) {
            Stopwatch timer = context.stat().detailTimer(DetailStat.BundleRun, bundle.getClass());
            bundle.run(env);
            timer.stop();
        }
        context.lifecycle().bundlesStarted(bundlesOrdered);
    }

    public static <T> List<T> removeDuplicates(List<T> list) {
        ArrayList registered = Lists.newArrayList();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            Class<?> type = it.next().getClass();
            if (registered.contains(type)) {
                it.remove();
                continue;
            }
            registered.add(type);
        }
        return list;
    }

    public static <T> List<T> removeTypes(List<T> list, List<Class<? extends T>> filter) {
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            Class<?> type = it.next().getClass();
            if (!filter.contains(type)) continue;
            it.remove();
        }
        return list;
    }

    public static <T> List<T> findBundles(Bootstrap bootstrap, Class<T> type) {
        ArrayList bundles = Lists.newArrayList(BundleSupport.resolveBundles(bootstrap, "configuredBundles"));
        bundles.removeIf(o -> !type.isAssignableFrom(o.getClass()));
        return bundles;
    }

    private static void initBundle(List<Class<? extends GuiceyBundle>> path, List<GuiceyBundle> initOrder, GuiceyBundle bundle, ConfigurationContext context, GuiceyBootstrap bootstrap) {
        Class<?> bundleType = bundle.getClass();
        if (path.contains(bundleType)) {
            String name = bundleType.getSimpleName();
            throw new IllegalStateException(String.format("Bundles registration loop detected: %s ) -> %s ...", path.stream().map(Class::getSimpleName).collect(Collectors.joining(" -> ")).replace(name, "( " + name), name));
        }
        path.add(bundleType);
        LOGGER.debug("Initializing bundle ({} level): {}", (Object)path.size(), (Object)bundleType.getName());
        ItemId id = ItemId.from(bundle);
        if (context.isBundleEnabled(id)) {
            ItemId currentScope = context.replaceContextScope(id);
            Stopwatch timer = context.stat().detailTimer(DetailStat.BundleInit, bundleType);
            try {
                bundle.initialize(bootstrap);
            }
            catch (Exception ex) {
                Throwables.throwIfUnchecked((Throwable)ex);
                throw new IllegalStateException("Guicey bundle initialization failed", ex);
            }
            timer.stop();
            initOrder.add(bundle);
            context.replaceContextScope(currentScope);
        }
        path.remove(bundleType);
    }

    private static <T> List<T> resolveBundles(Bootstrap bootstrap, String field) {
        try {
            Field declaredField = Bootstrap.class.getDeclaredField(field);
            declaredField.setAccessible(true);
            List res = (List)declaredField.get(bootstrap);
            declaredField.setAccessible(false);
            return (List)MoreObjects.firstNonNull((Object)res, Collections.emptyList());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve bootstrap field " + field, e);
        }
    }
}

