/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class InstanceUtils {
    private InstanceUtils() {
    }

    public static <T> T create(Class<T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate class with default constructor: " + type.getName(), ex);
        }
    }

    public static <T> T create(Class<T> type, Class<?> param, Object arg) {
        return InstanceUtils.create(type, new Class[]{param}, arg);
    }

    public static <T> T create(Class<T> type, Class<?>[] param, Object ... args) {
        try {
            return type.getConstructor(param).newInstance(args);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate class: " + type.getName() + "\n\t with constructor params: " + Arrays.stream(param).map(Class::getSimpleName).collect(Collectors.joining(", ")) + "\n\t and values: " + Arrays.stream(args).map(String::valueOf).collect(Collectors.joining(", ")), ex);
        }
    }

    public static <T> T createWithNulls(Class<T> type, Class<?> ... param) {
        Object[] args = new Object[param.length];
        Arrays.fill(args, null);
        return InstanceUtils.create(type, param, args);
    }

    public static <T> T createWithAnyConstructor(Class<T> type) {
        try {
            return InstanceUtils.create(type);
        }
        catch (RuntimeException ex) {
            Constructor<?> cand = null;
            for (Constructor<?> ctor : type.getDeclaredConstructors()) {
                if (cand != null && cand.getParameterCount() <= ctor.getParameterCount()) continue;
                cand = ctor;
            }
            if (cand != null) {
                return InstanceUtils.createWithNulls(type, cand.getParameterTypes());
            }
            throw new IllegalStateException("Failed to find suitable constructor for " + type);
        }
    }
}

