/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.context.SharedConfigurationState;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.dropwizard.guice.module.support.DropwizardAwareModule;

public final class StackUtils {
    private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final List<Class<?>> SHARED_STATE_INFRA = ImmutableList.of(SharedConfigurationState.class, GuiceyBootstrap.class, GuiceyEnvironment.class, DropwizardAwareModule.class, Optional.class);

    private StackUtils() {
    }

    public static Optional<StackWalker.StackFrame> getCaller(List<Class<?>> skip) {
        return WALKER.walk(stream -> stream.dropWhile(frame -> {
            Class<?> type = frame.getDeclaringClass();
            return type.equals(StackUtils.class) || type.getPackage().getName().startsWith("org.codehaus.groovy.vmplugin") || skip.contains(type) || skip.contains(type.getEnclosingClass());
        }).findFirst());
    }

    public static String getCallerSource(List<Class<?>> skip) {
        StackWalker.StackFrame frame = StackUtils.getCaller(skip).orElse(null);
        return "at " + (String)(frame != null ? RenderUtils.renderPackage(frame.getDeclaringClass()) + ".(" + frame.getFileName() + ":" + frame.getLineNumber() + ")" : "unknown source");
    }

    public static String getSharedStateSource() {
        return StackUtils.getCallerSource(SHARED_STATE_INFRA);
    }
}

