/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.yaml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ru.vyarus.java.generics.resolver.context.container.ParameterizedTypeImpl;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;

public class ConfigPath {
    private static final String QUOTE = "\"";
    private final ConfigPath root;
    private final List<ConfigPath> children = new ArrayList<ConfigPath>();
    private final Class declarationClass;
    private final Class declaredType;
    private final Class valueType;
    private final List<Type> declaredTypeGenerics;
    private final List<Type> valueTypeGenerics;
    private final String path;
    private final Object value;
    private final boolean customType;
    private final boolean objectDeclaration;
    private final Annotation qualifier;

    public ConfigPath(ConfigPath root, Class declarationClass, Class declaredType, Class valueType, List<Type> declaredTypeGenerics, List<Type> valueTypeGenerics, String path, Object value, boolean customType, boolean objectDeclaration, Annotation qualifier) {
        this.declarationClass = declarationClass;
        this.declaredType = declaredType;
        this.valueType = valueType;
        this.declaredTypeGenerics = declaredTypeGenerics;
        this.valueTypeGenerics = valueTypeGenerics;
        this.path = path;
        this.value = value;
        this.customType = customType;
        this.objectDeclaration = objectDeclaration;
        this.root = root;
        this.qualifier = qualifier;
    }

    public ConfigPath getRoot() {
        return this.root;
    }

    public List<ConfigPath> getChildren() {
        return this.children;
    }

    public Class getDeclarationClass() {
        return this.declarationClass;
    }

    public Class getDeclaredType() {
        return this.declaredType;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public List<Type> getDeclaredTypeGenerics() {
        return this.declaredTypeGenerics;
    }

    public List<Type> getValueTypeGenerics() {
        return this.valueTypeGenerics;
    }

    public String getPath() {
        return this.path;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isCustomType() {
        return this.customType;
    }

    public boolean isObjectDeclaration() {
        return this.objectDeclaration;
    }

    public Annotation getQualifier() {
        return this.qualifier;
    }

    public List<Class> getDeclaredTypeGenericClasses() {
        return this.getClasses(this.declaredTypeGenerics);
    }

    public List<Class> getValueTypeGenericClasses() {
        return this.getClasses(this.valueTypeGenerics);
    }

    public Class getRootDeclarationClass() {
        ConfigPath res = this;
        while (res.getRoot() != null) {
            res = res.getRoot();
        }
        return res.getDeclarationClass();
    }

    public Type getDeclaredTypeWithGenerics() {
        return this.getType(this.declaredType, this.declaredTypeGenerics);
    }

    public Type getTypeWithGenerics() {
        return this.getType(this.valueType, this.valueTypeGenerics);
    }

    public String getLastPathLevel() {
        int idx = this.path.lastIndexOf(46);
        return idx < 0 ? this.path : this.path.substring(idx + 1);
    }

    public String toStringDeclaredType() {
        return TypeToStringUtils.toStringType((Type)this.getDeclaredTypeWithGenerics(), Collections.emptyMap());
    }

    public String toStringType() {
        return TypeToStringUtils.toStringType((Type)this.getTypeWithGenerics(), Collections.emptyMap());
    }

    public String toStringValue() {
        return this.value instanceof String ? QUOTE + this.value + QUOTE : String.valueOf(this.value);
    }

    public String toString() {
        StringBuilder res = new StringBuilder(100).append('[').append(this.getRootDeclarationClass().getSimpleName()).append("] ").append(this.path).append(" (").append(this.toStringDeclaredType());
        if (this.isObjectDeclaration() && this.declaredType != Object.class) {
            res.append('*');
        }
        if (!this.declaredType.equals(this.valueType)) {
            res.append(" as ").append(this.toStringType());
        }
        res.append(") = ").append(this.toStringValue());
        return res.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigPath)) {
            return false;
        }
        ConfigPath that = (ConfigPath)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private List<Class> getClasses(List<Type> generics) {
        return generics.isEmpty() ? Collections.emptyList() : generics.stream().map(type -> GenericsUtils.resolveClass((Type)type, Collections.emptyMap())).collect(Collectors.toList());
    }

    private Type getType(Class<?> type, List<Type> generics) {
        return generics.isEmpty() ? type : new ParameterizedTypeImpl((Type)type, generics.toArray(new Type[0]), type.getEnclosingClass());
    }
}

