/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.env.field;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.platform.commons.util.ReflectionUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.TestFieldUtils;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.map.EmptyGenericsMap;

public class AnnotatedField<A extends Annotation, T> {
    private final A annotation;
    private final Field field;
    private final Class<?> testClass;
    private Map<String, Object> data;
    private T cachedValue;

    public AnnotatedField(A annotation, Field field, Class<?> testClass) {
        this.annotation = annotation;
        this.field = ReflectionUtils.makeAccessible((Field)field);
        this.testClass = testClass;
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public Class<T> getType() {
        return this.field.getType();
    }

    public List<Class<?>> getTypeParameters() {
        return GenericsUtils.resolveGenericsOf((Type)this.field.getGenericType(), (Map)EmptyGenericsMap.getInstance());
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public String getName() {
        return this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public T getValue(Object instance) {
        if (instance == null && !this.isStatic()) {
            throw new IllegalStateException("Field " + this.toStringField() + " is not static: test instance required for obtaining value");
        }
        if (!this.isCompatible(instance)) {
            throw new IllegalStateException("Invalid instance provided: " + (instance == null ? null : instance.getClass()) + " for field " + this.toStringField());
        }
        try {
            this.cachedValue = this.field.get(instance);
            return this.cachedValue;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get field " + this.toStringField() + " value", e);
        }
    }

    public T getValue(TestInstances instances) {
        return this.getValue(this.findRequiredInstance(instances));
    }

    public void setValue(Object instance, T value) {
        if (instance == null && !this.isStatic()) {
            throw new IllegalStateException("Field " + this.toStringField() + " is not static: test instance required for setting value");
        }
        if (!this.isCompatible(instance)) {
            throw new IllegalStateException("Invalid instance provided: " + (instance == null ? null : instance.getClass()) + " for field " + this.toStringField());
        }
        try {
            this.field.set(instance, value);
            this.cachedValue = value;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to set field " + this.toStringField() + " value to " + value, e);
        }
    }

    public void setValue(TestInstances instances, T value) {
        this.setValue(this.findRequiredInstance(instances), value);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean isTestOwnField() {
        return this.field.getDeclaringClass().equals(this.testClass);
    }

    public void requireStatic() {
        if (!this.isStatic()) {
            throw new IllegalStateException(String.format("Field %s annotated with @%s, must be static", this.toStringField(), this.annotation.annotationType().getSimpleName()));
        }
    }

    public void requireNonStatic() {
        if (this.isStatic()) {
            throw new IllegalStateException(String.format("Field %s annotated with @%s, must not be static", this.toStringField(), this.annotation.annotationType().getSimpleName()));
        }
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public boolean isCompatible(Object instance) {
        return this.isStatic() || instance != null && this.testClass.isAssignableFrom(instance.getClass());
    }

    public Object findRequiredInstance(TestInstances instances) {
        if (instances == null) {
            return null;
        }
        return instances.findInstance(this.testClass).orElseThrow(() -> new IllegalStateException("No test instance found for test class: " + this.testClass));
    }

    public void setCustomData(String key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, value);
    }

    public <K> K getCustomData(String key) {
        return (K)(this.data == null ? null : this.data.get(key));
    }

    public boolean isCustomDataSet(String key) {
        return this.data != null && this.data.get(key) != null;
    }

    public void clearCustomData() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    public String toStringField() {
        return TestFieldUtils.toString(this.field);
    }

    public T checkValueNotChanged(TestInstances instance) {
        T currentValue = this.cachedValue;
        T value = this.getValue(instance);
        if (value != currentValue) {
            throw new IllegalStateException(String.format("Field %s annotated with @%s value was changed: most likely, it happen in test setup method, which is called after Injector startup and so too late to change binding values. Manual initialization is possible in field directly.", this.toStringField(), this.annotation.annotationType().getSimpleName()));
        }
        return value;
    }

    public String toString() {
        return this.toStringField() + " (@" + this.annotation.annotationType().getSimpleName() + (this.isStatic() ? " static" : "") + " " + this.field.getType().getSimpleName() + ")";
    }
}

