/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.log;

import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.event.Level;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycle;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BeforeInitEvent;
import ru.vyarus.dropwizard.guice.test.log.RecordedLogs;
import ru.vyarus.dropwizard.guice.test.log.Recorder;

public class RecordLogsHook
implements GuiceyConfigurationHook {
    private final List<Recorder> recorders = new ArrayList<Recorder>();
    private final AtomicInteger counter = new AtomicInteger(1);

    @Override
    public void configure(GuiceBundle.Builder builder) throws Exception {
        this.recorders.forEach(Recorder::attach);
        builder.listen(event -> {
            if (event.getType().equals((Object)GuiceyLifecycle.BeforeInit)) {
                ((BeforeInitEvent)event).getBootstrap().addBundle((ConfiguredBundle)new RecordedLogsTrackingBundle());
            }
        });
    }

    public Builder record() {
        return new Builder();
    }

    public void clearLogs() {
        this.recorders.forEach(Recorder::clear);
    }

    public void destroy() {
        this.recorders.forEach(Recorder::destroy);
    }

    public final class RecordedLogsTrackingBundle
    implements ConfiguredBundle<Configuration> {
        public void run(Configuration configuration, Environment environment) throws Exception {
            RecordLogsHook.this.recorders.forEach(Recorder::attach);
        }
    }

    public class Builder {
        private String name;
        private final List<Class<?>> typedLoggers = new ArrayList();
        private final List<String> stringLoggers = new ArrayList<String>();

        public Builder recorderName(String name) {
            this.name = name;
            return this;
        }

        public Builder loggers(Class<?> ... typedLoggers) {
            Collections.addAll(this.typedLoggers, typedLoggers);
            return this;
        }

        public Builder loggers(String ... loggers) {
            Collections.addAll(this.stringLoggers, loggers);
            return this;
        }

        public RecordedLogs start(Level level) {
            ArrayList<String> loggers = new ArrayList<String>();
            if (!this.typedLoggers.isEmpty()) {
                loggers.addAll(this.typedLoggers.stream().map(Class::getName).collect(Collectors.toList()));
            }
            loggers.addAll(this.stringLoggers);
            Object id = this.name;
            if (id == null) {
                id = "Logs recorder #" + RecordLogsHook.this.counter.getAndIncrement();
            }
            Recorder recorder = new Recorder((String)id, level == null ? Level.WARN : level, loggers);
            RecordLogsHook.this.recorders.add(recorder);
            recorder.attach();
            return recorder.getRecordedLogs();
        }
    }
}

