/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.mock;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import java.util.HashMap;
import java.util.Map;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;

public class MocksHook
implements GuiceyConfigurationHook {
    private final Map<Class<?>, Object> mocks = new HashMap();
    private boolean initialized;

    @Override
    public void configure(GuiceBundle.Builder builder) throws Exception {
        if (!this.mocks.isEmpty()) {
            builder.modulesOverride(binder -> this.mocks.forEach((aClass, o) -> this.bindMock(binder, (Class<?>)aClass, o)));
        }
        this.initialized = true;
    }

    public <T> T mock(Class<T> type) {
        return (T)this.mock(type, Mockito.mock(type));
    }

    public <T> T mock(Class<T> type, T mock) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Too late. Mocks already applied.");
        Preconditions.checkState((boolean)MockUtil.isMock(mock), (Object)"Provided object is not a mockito mock object.");
        Preconditions.checkState((!this.mocks.containsKey(type) ? 1 : 0) != 0, (String)"Mock object for type %s is already registered.", (Object)type.getSimpleName());
        this.mocks.put(type, mock);
        return mock;
    }

    public <T> T getMock(Class<T> type) {
        return (T)Preconditions.checkNotNull((Object)this.mocks.get(type), (String)"Mock not registered for type %s", (Object)type.getSimpleName());
    }

    public void resetMocks() {
        this.mocks.values().forEach(xva$0 -> Mockito.reset((Object[])new Object[]{xva$0}));
    }

    private <K> void bindMock(Binder binder, Class<?> type, Object mock) {
        binder.bind(type).toInstance(mock);
    }
}

