/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.dropwizard.guice.test.rest.support.GuiceyJerseyTest;

public class RestClient {
    private static final List<Integer> DEFAULT_OK = Arrays.asList(200, 204);
    private final GuiceyJerseyTest jerseyTest;
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private final Map<String, String> defaultQueryParams = new HashMap<String, String>();
    private final List<String> defaultAccepts = new ArrayList<String>();
    private List<Integer> defaultStatus = DEFAULT_OK;

    public RestClient(GuiceyJerseyTest jerseyTest) {
        this.jerseyTest = jerseyTest;
    }

    public WebTarget target(String ... paths) {
        return paths.length > 0 ? this.getJerseyTest().target(PathUtils.path(paths)) : this.getJerseyTest().target();
    }

    public Client client() {
        return this.getJerseyTest().client();
    }

    public URI getBaseUri() {
        return this.getJerseyTest().getRootUri();
    }

    public RestClient defaultHeader(String name, String value) {
        this.defaultHeaders.put(name, value);
        return this;
    }

    public RestClient defaultQueryParam(String name, String value) {
        this.defaultQueryParams.put(name, value);
        return this;
    }

    public RestClient defaultOk(Integer ... codes) {
        this.defaultStatus = Arrays.asList(codes);
        return this;
    }

    public boolean hasDefaultHeaders() {
        return !this.defaultHeaders.isEmpty();
    }

    public boolean hasDefaultQueryParams() {
        return !this.defaultQueryParams.isEmpty();
    }

    public boolean hasDefaultAccepts() {
        return !this.defaultAccepts.isEmpty();
    }

    public boolean isDefaultStatusChanged() {
        return !this.defaultStatus.equals(DEFAULT_OK);
    }

    public RestClient defaultAccept(String ... accept) {
        Collections.addAll(this.defaultAccepts, accept);
        return this;
    }

    public Invocation.Builder request(String ... paths) {
        return this.applyDefaults(this.applyDefaults(this.target(paths)).request());
    }

    public <T> T get(String path, @Nullable Class<T> result) {
        if (result != null) {
            return (T)this.request(path).get(result);
        }
        this.checkVoidResponse(() -> this.request(path).get());
        return null;
    }

    public <T> T post(String path, @Nullable Object body, @Nullable Class<T> result) {
        return this.post(path, Entity.json((Object)body), result);
    }

    public <T> T post(String rootPath, @Nullable Entity<?> body, @Nullable Class<T> result) {
        if (result != null) {
            return (T)this.request(rootPath).post(body, result);
        }
        this.checkVoidResponse(() -> this.request(rootPath).post(body));
        return null;
    }

    public <T> T put(String path, @Nullable Object body, @Nullable Class<T> result) {
        return this.put(path, Entity.json((Object)body), result);
    }

    public <T> T put(String path, Entity<?> body, @Nullable Class<T> result) {
        if (result != null) {
            return (T)this.request(path).put(body, result);
        }
        this.checkVoidResponse(() -> this.request(path).put(body));
        return null;
    }

    public <T> T delete(String path, @Nullable Class<T> result) {
        if (result != null) {
            return (T)this.request(path).delete(result);
        }
        this.checkVoidResponse(() -> this.request(path).delete());
        return null;
    }

    public RestClient reset() {
        this.defaultHeaders.clear();
        this.defaultQueryParams.clear();
        this.defaultAccepts.clear();
        this.defaultStatus = DEFAULT_OK;
        return this;
    }

    private WebTarget applyDefaults(WebTarget request) {
        WebTarget res = request;
        if (!this.defaultQueryParams.isEmpty()) {
            for (Map.Entry<String, String> entry : this.defaultQueryParams.entrySet()) {
                res = res.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return res;
    }

    private Invocation.Builder applyDefaults(Invocation.Builder request) {
        if (!this.defaultHeaders.isEmpty()) {
            request.headers((MultivaluedMap)new MultivaluedHashMap(this.defaultHeaders));
        }
        if (!this.defaultAccepts.isEmpty()) {
            request.accept(this.defaultAccepts.toArray(new String[0]));
        }
        return request;
    }

    private void checkVoidResponse(Supplier<Response> call) {
        try (Response res = call.get();){
            if (!this.defaultStatus.contains(res.getStatus())) {
                throw new IllegalStateException("Invalid response: " + res.getStatus() + "\n" + (String)res.readEntity(String.class));
            }
        }
    }

    private GuiceyJerseyTest getJerseyTest() {
        return Objects.requireNonNull(this.jerseyTest);
    }
}

