/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.stub;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.stub.StubLifecycle;

public class StubsHook
implements GuiceyConfigurationHook {
    private final Map<Class<?>, Object> stubs = new HashMap();
    private final Map<Class<?>, Provider<?>> stubProviders = new HashMap();
    private boolean initialized;

    @Override
    public void configure(GuiceBundle.Builder builder) throws Exception {
        if (!this.stubs.isEmpty()) {
            builder.modulesOverride(binder -> this.stubs.forEach((aClass, o) -> this.bindStub(binder, (Class<?>)aClass, o)));
        }
        this.initialized = true;
    }

    public <T> void stub(Class<T> type, Class<? extends T> stub) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Too late. Spies already applied.");
        Preconditions.checkState((!type.equals(stub) ? 1 : 0) != 0, (Object)"Stub must have a different type.");
        Preconditions.checkState((!this.stubs.containsKey(type) ? 1 : 0) != 0, (String)"Stub object for type %s is already registered.", (Object)type.getSimpleName());
        this.stubs.put(type, stub);
    }

    public <T> void stub(Class<T> type, T value) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Too late. Spies already applied.");
        Preconditions.checkNotNull(value, (Object)"Stub cannot be null");
        Preconditions.checkState((!this.stubs.containsKey(type) ? 1 : 0) != 0, (String)"Stub object for type %s is already registered.", (Object)type.getSimpleName());
        this.stubs.put(type, value);
    }

    public void before() {
        this.lifecycle(true);
    }

    public void after() {
        this.lifecycle(false);
    }

    private void lifecycle(boolean before) {
        this.stubs.keySet().forEach(type -> {
            Object stub = this.getStub((Class)type);
            if (stub instanceof StubLifecycle) {
                StubLifecycle lifecycle = (StubLifecycle)stub;
                if (before) {
                    lifecycle.before();
                } else {
                    lifecycle.after();
                }
            }
        });
    }

    public <T, P extends T> P getStub(Class<T> type) {
        Object stub = Preconditions.checkNotNull((Object)this.stubs.get(type), (String)"Stub not registered for type %s", (Object)type.getSimpleName());
        return (P)(stub instanceof Class ? this.stubProviders.get(type).get() : stub);
    }

    private <K> void bindStub(Binder binder, Class<?> type, Object stub) {
        if (stub instanceof Class) {
            binder.bind(type).to((Class)stub).in(Singleton.class);
            this.stubProviders.put(type, binder.getProvider(type));
        } else {
            binder.requestInjection(stub);
            binder.bind(type).toInstance(stub);
        }
    }
}

