/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.track;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.mockito.Mockito;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.debugging.LocationFactory;
import org.mockito.internal.invocation.InterceptedInvocation;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.mockref.MockStrongReference;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MatchableInvocation;
import org.mockito.stubbing.OngoingStubbing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.test.track.MethodTrack;
import ru.vyarus.dropwizard.guice.test.track.TrackerConfig;
import ru.vyarus.dropwizard.guice.test.track.stat.TrackerStats;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;

public class Tracker<T> {
    private final Logger logger = LoggerFactory.getLogger(Tracker.class);
    private final Class<T> type;
    private final TrackerConfig config;
    private final Duration warn;
    private final List<MethodTrack> tracks = new CopyOnWriteArrayList<MethodTrack>();
    private final Map<Method, Timer> timers = new ConcurrentHashMap<Method, Timer>();
    private MetricRegistry metrics;
    private Object innerMock;
    private MockStrongReference<Object> reference;

    public Tracker(Class<T> type, TrackerConfig config, MetricRegistry metrics) {
        this.type = type;
        this.config = config;
        this.warn = config.getSlowMethods() > 0L ? Duration.of(config.getSlowMethods(), config.getSlowMethodsUnit()) : null;
        this.metrics = metrics;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.tracks.isEmpty();
    }

    public int size() {
        return this.tracks.size();
    }

    public List<MethodTrack> getTracks() {
        return new ArrayList<MethodTrack>(this.tracks);
    }

    public MethodTrack getLastTrack() {
        Preconditions.checkState((!this.tracks.isEmpty() ? 1 : 0) != 0, (Object)"No tracks registered");
        return this.tracks.get(this.tracks.size() - 1);
    }

    public List<MethodTrack> getLastTracks(int count) {
        Preconditions.checkState((this.tracks.size() >= count ? 1 : 0) != 0, (String)"Not enough tracks registered: requested %s but only %s registered", (int)count, (int)this.tracks.size());
        return this.tracks.subList(this.tracks.size() - count, this.tracks.size());
    }

    public TrackerStats getStats() {
        return new TrackerStats(this.tracks);
    }

    public List<MethodTrack> findTracks(Function<T, OngoingStubbing<?>> where) {
        OngoingStubbing<?> apply = where.apply(this.mock());
        InvocationContainerImpl invocationContainer = MockUtil.getInvocationContainer(this.mock());
        try {
            MatchableInvocation matcher = (MatchableInvocation)FieldUtils.readDeclaredField((Object)invocationContainer, (String)"invocationForStubbing", (boolean)true);
            ArrayList<MethodTrack> result = new ArrayList<MethodTrack>();
            for (MethodTrack track : this.tracks) {
                if (!matcher.matches((Invocation)this.from(track))) continue;
                result.add(track);
            }
            ArrayList<MethodTrack> arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to find tracker method", ex);
        }
        finally {
            apply.thenReturn(null);
            MockUtil.resetMock(this.mock());
        }
    }

    public void clear() {
        this.tracks.clear();
        this.timers.clear();
        this.metrics = new MetricRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Method method, String instanceHash, long started, Duration duration, Object[] rawArguments, String[] arguments, Object rawResult, String result, Throwable throwable, boolean[] stringMarkers) {
        Timer timer = this.getTimer(method);
        timer.update(duration);
        MethodTrack track = new MethodTrack(this.type, method, instanceHash, started, duration, (Object[])(this.config.isKeepRawObjects() ? rawArguments : null), arguments, this.config.isKeepRawObjects() ? rawResult : null, result, throwable, stringMarkers, timer);
        List<MethodTrack> list = this.tracks;
        synchronized (list) {
            this.tracks.add(track);
            Collections.sort(this.tracks);
        }
        if (this.config.isTrace() || this.warn != null && duration.compareTo(this.warn) > 0) {
            String msg = "\\\\\\---[Tracker<" + this.type.getSimpleName() + ">]" + String.format(" %-12s <@%s> .%s", PrintUtils.ms(track.getDuration()), instanceHash, track.toStringTrack());
            if (this.config.isTrace()) {
                System.out.println(msg);
            } else {
                this.logger.warn("\n" + msg);
            }
        }
    }

    private Timer getTimer(Method method) {
        return this.timers.computeIfAbsent(method, k -> this.metrics.timer(this.type.getName() + "." + method.getName() + "." + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(","))));
    }

    private T mock() {
        if (this.innerMock == null) {
            this.innerMock = Mockito.mock(this.type);
            this.reference = new MockStrongReference(this.innerMock, false);
        }
        return (T)this.innerMock;
    }

    private InterceptedInvocation from(MethodTrack track) {
        return new InterceptedInvocation(this.reference, (MockitoMethod)new DelegatingMethod(track.getMethod()), track.getRawArguments(), null, LocationFactory.create(), SequenceNumber.next());
    }
}

