/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.track.stat;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.test.track.MethodTrack;
import ru.vyarus.dropwizard.guice.test.track.Tracker;
import ru.vyarus.dropwizard.guice.test.track.stat.MethodSummary;

public class TrackerStats {
    private final List<MethodSummary> methods;

    public TrackerStats(Tracker ... trackers) {
        this(Arrays.stream(trackers).map(Tracker::getTracks).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public TrackerStats(List<MethodTrack> tracks) {
        this.methods = this.buildSummary(tracks);
    }

    public List<MethodSummary> getMethods() {
        return this.methods;
    }

    public String render() {
        if (this.methods.isEmpty()) {
            return null;
        }
        String format = "%-40s %-50s %-10s %-10s %-10s %-10s %-10s %-10s %-10s%n";
        StringBuilder builder = new StringBuilder();
        builder.append('\t').append(String.format("%-40s %-50s %-10s %-10s %-10s %-10s %-10s %-10s %-10s%n", "[service]", "[method]", "[calls]", "[fails]", "[min]", "[max]", "[median]", "[75%]", "[95%]"));
        for (MethodSummary summary : this.methods) {
            builder.append('\t').append(String.format("%-40s %-50s %-10s %-10s %-10s %-10s %-10s %-10s %-10s%n", summary.getService().getSimpleName(), summary.toStringMethod(), summary.getTracks() + (String)(summary.getInstancesCount() > 1 ? " (" + summary.getInstancesCount() + ")" : ""), summary.getErrors(), summary.getMin(), summary.getMax(), summary.getMedian(), summary.get75thPercentile(), summary.get95thPercentile()));
        }
        return builder.toString();
    }

    private List<MethodSummary> buildSummary(List<MethodTrack> tracks) {
        HashMap<Method, MethodSummary> idx = new HashMap<Method, MethodSummary>();
        for (MethodTrack track : tracks) {
            idx.computeIfAbsent(track.getMethod(), method -> new MethodSummary(track.getService(), track.getMethod(), track.getTimer())).add(track);
        }
        ArrayList<MethodSummary> res = new ArrayList<MethodSummary>(idx.values());
        Collections.sort(res);
        Collections.reverse(res);
        return res;
    }
}

