/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import java.util.ArrayList;
import java.util.List;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.installer.util.InstanceUtils;

public final class HooksUtil {
    private HooksUtil() {
    }

    @SafeVarargs
    public static List<GuiceyConfigurationHook> create(Class<? extends GuiceyConfigurationHook> ... hooks) {
        ArrayList<GuiceyConfigurationHook> res = new ArrayList<GuiceyConfigurationHook>();
        for (Class<? extends GuiceyConfigurationHook> hook : hooks) {
            try {
                res.add(InstanceUtils.create(hook));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate guicey hook: " + hook.getSimpleName(), e);
            }
        }
        return res;
    }

    public static void register(List<GuiceyConfigurationHook> hooks) {
        if (hooks != null) {
            for (GuiceyConfigurationHook hook : hooks) {
                if (hook == null) continue;
                hook.register();
            }
        }
    }
}

