/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.info.BundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.GuiceyBundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.InstallerItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.sign.DisableSupport;
import ru.vyarus.dropwizard.guice.module.context.info.sign.ScanSupport;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;

public final class Filters {
    private Filters() {
    }

    public static <T extends ItemInfo> Predicate<T> enabled() {
        return input -> !(input instanceof DisableSupport) || ((DisableSupport)((Object)input)).isEnabled();
    }

    public static <T extends ItemInfo> Predicate<T> disabled() {
        return Filters.enabled().negate();
    }

    public static <T extends ItemInfo> Predicate<T> disabledBy(ItemId scope) {
        return input -> input instanceof DisableSupport && ((DisableSupport)((Object)input)).getDisabledBy().contains(scope);
    }

    public static <T extends ItemInfo> Predicate<T> disabledBy(Class<?> type) {
        return Filters.disabledBy(ItemId.from(type));
    }

    public static <T extends ItemInfo> Predicate<T> fromScan() {
        return input -> input instanceof ScanSupport && ((ScanSupport)((Object)input)).isFromScan();
    }

    public static <T extends ItemInfo> Predicate<T> registrationScope(ItemId scope) {
        return input -> scope.equals(input.getRegistrationScope());
    }

    public static <T extends ItemInfo> Predicate<T> registrationScope(ConfigScope specialScope) {
        return Filters.registrationScope(specialScope.getType());
    }

    public static <T extends ItemInfo> Predicate<T> registrationScope(Class<?> type) {
        return Filters.registrationScope(ItemId.from(type));
    }

    public static <T extends ItemInfo> Predicate<T> registeredBy(ItemId scope) {
        return input -> input.getRegisteredBy().contains(scope);
    }

    public static <T extends ItemInfo> Predicate<T> registeredBy(ConfigScope specialScope) {
        return Filters.registeredBy(specialScope.getKey());
    }

    public static <T extends ItemInfo> Predicate<T> registeredBy(Class<?> type) {
        return Filters.registeredBy(ItemId.from(type));
    }

    public static <T extends ItemInfo> Predicate<T> type(ConfigItem ... types) {
        List<ConfigItem> target = Arrays.asList(types);
        return input -> target.contains((Object)input.getItemType());
    }

    public static <T extends ItemInfo> Predicate<T> type(Class<?> type) {
        return input -> input.getType().equals(type);
    }

    public static Predicate<GuiceyBundleItemInfo> lookupBundles() {
        return GuiceyBundleItemInfo::isFromLookup;
    }

    public static Predicate<BundleItemInfo> transitiveBundles() {
        return BundleItemInfo::isTransitive;
    }

    public static <T extends BundleItemInfo> Predicate<T> bundles() {
        return Filters.type(ConfigItem.Bundle).or(Filters.type(ConfigItem.DropwizardBundle));
    }

    public static Predicate<GuiceyBundleItemInfo> guiceyBundles() {
        return Filters.type(ConfigItem.Bundle);
    }

    public static Predicate<GuiceyBundleItemInfo> dropwizardBundles() {
        return Filters.type(ConfigItem.DropwizardBundle);
    }

    public static Predicate<ExtensionItemInfo> extensions() {
        return Filters.type(ConfigItem.Extension);
    }

    public static Predicate<ExtensionItemInfo> installedBy(Class<? extends FeatureInstaller> type) {
        return input -> type.equals(input.getInstalledBy());
    }

    public static Predicate<ExtensionItemInfo> fromBinding() {
        return ExtensionItemInfo::isGuiceBinding;
    }

    public static Predicate<ExtensionItemInfo> webExtension() {
        return ExtensionItemInfo::isWebExtension;
    }

    public static Predicate<ExtensionItemInfo> jerseyExtension() {
        return ExtensionItemInfo::isJerseyExtension;
    }

    public static Predicate<ModuleItemInfo> modules() {
        return Filters.type(ConfigItem.Module);
    }

    public static Predicate<ModuleItemInfo> overridingModule() {
        return ModuleItemInfo::isOverriding;
    }

    public static Predicate<InstallerItemInfo> installers() {
        return Filters.type(ConfigItem.Installer);
    }
}

