/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.jersey;

import com.google.inject.Binder;
import com.google.inject.binder.AnnotatedBindingBuilder;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.JerseyManaged;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.LazyBinding;
import ru.vyarus.dropwizard.guice.module.installer.option.InstallerOptionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;

public abstract class AbstractJerseyInstaller<T>
extends InstallerOptionsSupport
implements FeatureInstaller,
JerseyInstaller<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected boolean isLazy(Class<?> type, boolean lazy) {
        if (this.isJerseyExtension(type) && lazy) {
            this.logger.warn("@{} is ignored, because @{} set: {}", new Object[]{LazyBinding.class.getSimpleName(), JerseyManaged.class.getSimpleName(), type.getName()});
            return false;
        }
        return lazy;
    }

    protected boolean isJerseyExtension(Class<?> type) {
        return JerseyBinding.isJerseyManaged(type, (Boolean)this.option(InstallersOptions.JerseyExtensionsManagedByGuice));
    }

    protected void bindInGuice(Binder binder, Class<?> type) {
        AnnotatedBindingBuilder binding = binder.bind(type);
        if (this.isForceSingleton(type, false)) {
            binding.in(Singleton.class);
        }
    }

    protected boolean isForceSingleton(Class<?> type, boolean hkManaged) {
        return (Boolean)this.option(InstallersOptions.ForceSingletonForJerseyExtensions) != false && !this.hasScopeAnnotation(type, hkManaged);
    }

    private boolean hasScopeAnnotation(Class<?> type, boolean hkManaged) {
        return BindingUtils.findScopingAnnotation(type, !hkManaged) != null;
    }
}

