/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.OptionalExtensionDisablerScope;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ExtensionItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.JerseyManaged;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.TypeInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.LazyBinding;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.installer.scanner.InvisibleForScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;

public final class ExtensionsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionsSupport.class);

    private ExtensionsSupport() {
    }

    public static boolean registerExtension(ConfigurationContext context, Class<?> type, boolean fromScan) {
        FeatureInstaller installer = ExtensionsSupport.findInstaller(type, context.getExtensionsHolder().getInstallers());
        return ExtensionsSupport.registerExtension(context, type, installer, fromScan);
    }

    public static boolean registerExtension(ConfigurationContext context, Class<?> type, FeatureInstaller installer, boolean fromScan) {
        ExtensionItemInfoImpl info;
        boolean recognized;
        boolean bl = recognized = installer != null;
        if (recognized) {
            ExtensionItemInfoImpl info2 = context.getOrRegisterExtension(type, fromScan);
            info2.setLazy(type.isAnnotationPresent(LazyBinding.class));
            info2.setJerseyManaged(JerseyBinding.isJerseyManaged(type, (Boolean)context.option(InstallersOptions.JerseyExtensionsManagedByGuice)));
            info2.setInstaller(installer);
            context.notifyExtensionRecognized(info2);
        } else if (!fromScan && (info = context.getOrRegisterExtension(type, fromScan)).isOptional()) {
            LOGGER.debug("Optional extension disabled: {}", (Object)type.getName());
            context.openScope(ItemId.from(OptionalExtensionDisablerScope.class));
            context.disableExtensions(new Class[]{type});
            context.closeScope();
            recognized = true;
        }
        return recognized;
    }

    public static boolean registerExtensionBinding(ConfigurationContext context, Class<?> type, Binding<?> manualBinding, Class<? extends Module> topDeclarationModule) {
        boolean recognized;
        if (FeatureUtils.hasAnnotation(type, InvisibleForScanner.class)) {
            return false;
        }
        FeatureInstaller installer = ExtensionsSupport.findInstaller(type, context.getExtensionsHolder().getInstallers());
        boolean bl = recognized = installer != null;
        if (recognized) {
            ExtensionItemInfoImpl info = context.getOrRegisterBindingExtension(type, topDeclarationModule);
            info.setLazy(type.isAnnotationPresent(LazyBinding.class));
            info.setJerseyManaged(JerseyBinding.isJerseyManaged(type, (Boolean)context.option(InstallersOptions.JerseyExtensionsManagedByGuice)));
            Preconditions.checkState((!info.isLazy() ? 1 : 0) != 0, (String)"@%s annotation must not be used on manually bound extension: %s", (Object)LazyBinding.class.getSimpleName(), (Object)type.getName());
            Preconditions.checkState((!info.isJerseyManaged() ? 1 : 0) != 0, (String)"Extension manually bound in guice module can't be marked as jersey managed (@%s): %s", (Object)JerseyManaged.class.getSimpleName(), (Object)type.getName());
            info.setManualBinding(manualBinding);
            info.setInstaller(installer);
            context.notifyExtensionRecognized(info);
        }
        return recognized;
    }

    public static void installExtensions(ConfigurationContext context, Injector injector) {
        ExtensionsHolder holder = context.getExtensionsHolder();
        holder.order();
        ArrayList allInstalled = new ArrayList();
        context.lifecycle().injectorPhase(injector);
        for (FeatureInstaller installer : holder.getInstallers()) {
            List<Class<?>> res = holder.getExtensions(installer.getClass());
            if (res != null) {
                for (Class<?> inst : res) {
                    if (installer instanceof TypeInstaller) {
                        ((TypeInstaller)((Object)installer)).install(context.getEnvironment(), inst);
                    }
                    if (installer instanceof InstanceInstaller) {
                        ((InstanceInstaller)((Object)installer)).install(context.getEnvironment(), injector.getInstance(inst));
                    }
                    LOGGER.trace("{} extension installed: {}", (Object)FeatureUtils.getInstallerExtName(installer.getClass()), (Object)inst.getName());
                }
            }
            if (installer instanceof JerseyInstaller) continue;
            installer.report();
            context.lifecycle().extensionsInstalled(installer.getClass(), res);
            if (res == null) continue;
            allInstalled.addAll(res);
        }
        context.lifecycle().extensionsInstalled(allInstalled);
    }

    public static FeatureInstaller findInstaller(Class<?> type, List<FeatureInstaller> installers) {
        for (FeatureInstaller installer : installers) {
            if (!installer.matches(type)) continue;
            return installer;
        }
        return null;
    }
}

