/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.internal.MoreTypes;
import com.google.inject.internal.PrivateElementsImpl;
import com.google.inject.internal.Scoping;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.UntargettedBinding;
import com.google.inject.util.Modules;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.module.GuiceBootstrapModule;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatTimer;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;
import ru.vyarus.dropwizard.guice.module.support.BootstrapAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationTreeAwareModule;
import ru.vyarus.dropwizard.guice.module.support.EnvironmentAwareModule;
import ru.vyarus.dropwizard.guice.module.support.OptionsAwareModule;

public final class ModulesSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModulesSupport.class);

    private ModulesSupport() {
    }

    public static void configureModules(ConfigurationContext context) {
        for (Module mod : context.getEnabledModules()) {
            if (mod instanceof BootstrapAwareModule) {
                ((BootstrapAwareModule)mod).setBootstrap(context.getBootstrap());
            }
            if (mod instanceof ConfigurationAwareModule) {
                ((ConfigurationAwareModule)mod).setConfiguration(context.getConfiguration());
            }
            if (mod instanceof ConfigurationTreeAwareModule) {
                ((ConfigurationTreeAwareModule)mod).setConfigurationTree(context.getConfigurationTree());
            }
            if (mod instanceof EnvironmentAwareModule) {
                ((EnvironmentAwareModule)mod).setEnvironment(context.getEnvironment());
            }
            if (!(mod instanceof OptionsAwareModule)) continue;
            ((OptionsAwareModule)mod).setOptions(context.optionsReadOnly());
        }
    }

    public static Iterable<Module> prepareModules(ConfigurationContext context) {
        StatTimer timer = context.stat().timer(Stat.ModulesProcessingTime);
        List<Module> overridingModules = context.getOverridingModules();
        List<Module> normalModules = ModulesSupport.analyzeModules(context, timer);
        List<Module> res = overridingModules.isEmpty() ? normalModules : Collections.singletonList(Modules.override(normalModules).with(overridingModules));
        timer.stop();
        return res;
    }

    private static List<Module> analyzeModules(ConfigurationContext context, StatTimer modulesTimer) {
        List<Module> modules;
        block3: {
            modules = context.getNormalModules();
            Boolean configureFromGuice = (Boolean)context.option(GuiceyOptions.AnalyzeGuiceModules);
            if (modules.size() > 1 && configureFromGuice.booleanValue()) {
                GuiceBootstrapModule bootstrap = (GuiceBootstrapModule)modules.remove(modules.size() - 1);
                try {
                    StatTimer gtime = context.stat().timer(Stat.BindingsResolutionTime);
                    ArrayList<Element> elements = new ArrayList<Element>(Elements.getElements((Stage)((Stage)context.option(GuiceyOptions.InjectorStage)), modules));
                    gtime.stop();
                    modulesTimer.stop();
                    ModulesSupport.analyzeAndFilterBindings(context, modules, elements);
                    modulesTimer.start();
                    modules = Arrays.asList(Elements.getModule(elements), bootstrap);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to analyze guice bindings - skipping this step. Note that configuration from bindings may be switched off with " + GuiceyOptions.class.getSimpleName() + "." + GuiceyOptions.AnalyzeGuiceModules.name() + " option.", (Throwable)ex);
                    modules.add((Module)bootstrap);
                    if (modulesTimer.isRunning()) break block3;
                    modulesTimer.start();
                }
            }
        }
        return modules;
    }

    private static void analyzeAndFilterBindings(ConfigurationContext context, List<Module> analyzedModules, List<Element> elements) {
        StatTimer itimer = context.stat().timer(Stat.InstallersTime);
        StatTimer timer = context.stat().timer(Stat.ExtensionsRecognitionTime);
        StatTimer analysisTimer = context.stat().timer(Stat.BindingsAnalysisTime);
        List<String> disabledModules = ModulesSupport.prepareDisabledModules(context);
        AnalysisResult result = ModulesSupport.analyzeElements(context, elements, disabledModules, null);
        if (!result.actuallyDisabledModules.isEmpty()) {
            LOGGER.debug("Removed inner guice modules: {}", result.actuallyDisabledModules);
        }
        context.stat().count(Stat.RemovedInnerModules, result.actuallyDisabledModules.size());
        context.stat().count(Stat.RemovedBindingsCount, result.removedBindings.size());
        context.lifecycle().modulesAnalyzed(analyzedModules, result.extensions, ModulesSupport.toModuleClasses(result.actuallyDisabledModules), result.removedBindings);
        analysisTimer.stop();
        timer.stop();
        itimer.stop();
    }

    private static AnalysisResult analyzeElements(ConfigurationContext context, List<Element> elements, List<String> disabledModules, Predicate<Key> privateFilter) {
        context.stat().count(Stat.BindingsCount, elements.size());
        HashSet<String> actuallyDisabledModules = new HashSet<String>();
        ArrayList<Binding> removedBindings = new ArrayList<Binding>();
        ArrayList extensions = new ArrayList();
        LinkedHashMultimap linkedBindings = LinkedHashMultimap.create();
        Iterator<Element> it = elements.iterator();
        while (it.hasNext()) {
            Element element = it.next();
            if (ModulesSupport.isInDisabledModule(element, disabledModules, actuallyDisabledModules)) {
                it.remove();
                context.stat().count(Stat.RemovedBindingsCount, 1);
                continue;
            }
            if (element instanceof Binding && ModulesSupport.detectExtensionAndRemoveBindingIfDisabled(context, (Binding)element, extensions, (Multimap<Key, LinkedKeyBinding>)linkedBindings, privateFilter)) {
                it.remove();
                removedBindings.add((Binding)element);
                continue;
            }
            if (!(element instanceof PrivateElements) || privateFilter != null || !((Boolean)context.option(GuiceyOptions.AnalyzePrivateGuiceModules)).booleanValue()) continue;
            AnalysisResult analysisResult = ModulesSupport.analyzePrivateModule((PrivateElements)element, context, disabledModules);
            extensions.addAll(analysisResult.extensions);
            removedBindings.addAll(analysisResult.removedBindings);
            actuallyDisabledModules.addAll(analysisResult.actuallyDisabledModules);
        }
        for (Binding binding : ModulesSupport.detectExtensionsInLinkedBindingsAndRemoveDisabled(context, extensions, (Multimap<Key, LinkedKeyBinding>)linkedBindings, privateFilter)) {
            elements.remove(binding);
            removedBindings.add(binding);
        }
        return new AnalysisResult(extensions, removedBindings, actuallyDisabledModules);
    }

    private static boolean detectExtensionAndRemoveBindingIfDisabled(ConfigurationContext context, Binding binding, List<Class<?>> extensions, Multimap<Key, LinkedKeyBinding> linkedBindings, Predicate<Key> privateFilter) {
        Key key = binding.getKey();
        if (ModulesSupport.isPossibleExtension(key, privateFilter)) {
            context.stat().count(Stat.AnalyzedBindingsCount, 1);
            Class type = key.getTypeLiteral().getRawType();
            if (context.isAcceptableAutoScanClass(type) && ExtensionsSupport.registerExtensionBinding(context, type, binding, BindingUtils.getTopDeclarationModule((Element)binding))) {
                LOGGER.debug("Extension detected from guice binding: {}", (Object)type.getSimpleName());
                extensions.add(type);
                return !context.isExtensionEnabled(type);
            }
        }
        if (binding instanceof LinkedKeyBinding) {
            LinkedKeyBinding linkedBind = (LinkedKeyBinding)binding;
            linkedBindings.put((Object)linkedBind.getLinkedKey(), (Object)linkedBind);
        }
        return false;
    }

    private static boolean isPossibleExtension(Key key, Predicate<Key> filter) {
        return key.getAnnotation() == null && key.getTypeLiteral().getType() instanceof Class && (filter == null || filter.test(key));
    }

    private static List<LinkedKeyBinding> detectExtensionsInLinkedBindingsAndRemoveDisabled(ConfigurationContext context, List<Class<?>> extensions, Multimap<Key, LinkedKeyBinding> links, Predicate<Key> privateFilter) {
        for (Map.Entry entry : links.entries()) {
            Key key = (Key)entry.getKey();
            Class type = key.getTypeLiteral().getRawType();
            LinkedKeyBinding binding = (LinkedKeyBinding)entry.getValue();
            if (!ModulesSupport.isPossibleExtension(key, privateFilter) || extensions.contains(type) || !context.isAcceptableAutoScanClass(type) || !ExtensionsSupport.registerExtensionBinding(context, type, binding, BindingUtils.getTopDeclarationModule((Element)binding))) continue;
            LOGGER.debug("Extension detected from guice linked binding: {}", (Object)type.getSimpleName());
            extensions.add(type);
        }
        List<Key> removedExtensions = extensions.stream().filter(it -> !context.isExtensionEnabled((Class<?>)it)).map(Key::get).collect(Collectors.toList());
        return ModulesSupport.removeChains(removedExtensions, links);
    }

    private static List<LinkedKeyBinding> removeChains(List<Key> removed, Multimap<Key, LinkedKeyBinding> bindings) {
        ArrayList<Key> newlyRemoved = new ArrayList<Key>();
        ArrayList<LinkedKeyBinding> res = new ArrayList<LinkedKeyBinding>();
        for (Key removedKey : removed) {
            for (LinkedKeyBinding bnd : bindings.get((Object)removedKey)) {
                res.add(bnd);
                newlyRemoved.add(bnd.getKey());
            }
        }
        if (!newlyRemoved.isEmpty()) {
            res.addAll(ModulesSupport.removeChains(newlyRemoved, bindings));
        }
        return res;
    }

    private static AnalysisResult analyzePrivateModule(PrivateElements privateModule, ConfigurationContext context, List<String> disabledModules) {
        PrivateElementsImpl module = (PrivateElementsImpl)privateModule;
        PrivateExposedFilter filter = new PrivateExposedFilter(module);
        AnalysisResult result = ModulesSupport.analyzeElements(context, module.getElementsMutable(), disabledModules, filter);
        ArrayList<Class> toExpose = new ArrayList<Class>();
        for (Class<?> ext : result.extensions) {
            Key expose;
            if (!context.isExtensionEnabled(ext) || (expose = (Key)Preconditions.checkNotNull((Object)filter.detected.get(ext), (String)"Exposed key not found for detected extension : %s", (Object)ext.getName())).getTypeLiteral().getRawType().equals(ext)) continue;
            LOGGER.debug("Extension {} is indirectly exposed from private module by key {}. Adding direct expose", ext, (Object)expose);
            toExpose.add(ext);
        }
        ModulesSupport.exposeIndirectPrivateModuleExtensions(toExpose, filter.boundKeys, result.removedBindings, module);
        return result;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private static void exposeIndirectPrivateModuleExtensions(List<Class> notExposed, Set<Key<?>> boundKeys, List<Binding> removedBindings, PrivateElementsImpl module) {
        try {
            Field exposedKeysField = PrivateElementsImpl.class.getDeclaredField("exposedKeysToSources");
            exposedKeysField.setAccessible(true);
            HashMap<Key, CallSite> exposedKeys = new HashMap<Key, CallSite>((Map)exposedKeysField.get(module));
            for (Binding binding : removedBindings) {
                exposedKeys.remove(binding.getKey());
                if (!(binding instanceof LinkedKeyBinding)) continue;
                exposedKeys.remove(((LinkedKeyBinding)binding).getLinkedKey());
            }
            Constructor<?> ctor = Class.forName("com.google.inject.internal.UntargettedBindingImpl").getDeclaredConstructor(Object.class, Key.class, Scoping.class);
            ctor.setAccessible(true);
            for (Class ext : notExposed) {
                LOGGER.debug("Registering synthetic bindings for private module to expose extension: {}", (Object)ext.getName());
                Key key = MoreTypes.canonicalizeKey((Key)Key.get((Class)ext));
                if (!boundKeys.contains(key)) {
                    module.getElementsMutable().add((UntargettedBinding)ctor.newInstance("Synthetic binding to expose extension directly: " + ext.getName(), key, Scoping.UNSCOPED));
                }
                exposedKeys.put(key, (CallSite)((Object)("Synthetic exposure for extension: " + ext.getName())));
            }
            exposedKeysField.set(module, ImmutableMap.copyOf(exposedKeys));
            exposedKeysField.setAccessible(false);
            ctor.setAccessible(false);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to override exposed keys for private module", e);
        }
    }

    private static Key findExposed(Key key, Multimap<Key, LinkedKeyBinding> linkedBindings, Set<Key<?>> exposedKeys) {
        Key res;
        Object object = res = exposedKeys.contains(key) ? key : null;
        if (res == null) {
            for (LinkedKeyBinding target : linkedBindings.get((Object)key)) {
                Key exposed = ModulesSupport.findExposed(target.getKey(), linkedBindings, exposedKeys);
                if (exposed == null) continue;
                res = exposed;
                break;
            }
        }
        return res;
    }

    private static List<String> prepareDisabledModules(ConfigurationContext context) {
        ArrayList<String> res = new ArrayList<String>();
        for (Class<Object> cls : context.getDisabledModuleTypes()) {
            res.add(cls.getName());
        }
        return res;
    }

    private static boolean isInDisabledModule(Element element, List<String> disabled, Set<String> actuallyDisabled) {
        if (!disabled.isEmpty()) {
            List<String> modules = BindingUtils.getModules(element);
            for (int i = modules.size() - 1; i >= 0; --i) {
                String mod = modules.get(i);
                if (!disabled.contains(mod)) continue;
                actuallyDisabled.add(mod);
                return true;
            }
        }
        return false;
    }

    private static List<Class<? extends Module>> toModuleClasses(Set<String> modules) {
        if (modules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Class<? extends Module>> res = new ArrayList<Class<? extends Module>>();
        for (String mod : modules) {
            res.add(BindingUtils.getModuleClass(mod));
        }
        return res;
    }

    private static class PrivateExposedFilter
    implements Predicate<Key> {
        public final Set<Key<?>> boundKeys;
        public final Map<Class, Key> detected = new HashMap<Class, Key>();
        private final Multimap<Key, LinkedKeyBinding> linkedBindings;
        private final Set<Key<?>> exposedKeys;

        PrivateExposedFilter(PrivateElementsImpl module) {
            this.exposedKeys = module.getExposedKeys();
            this.boundKeys = new HashSet();
            this.linkedBindings = LinkedHashMultimap.create();
            for (Element element : module.getElementsMutable()) {
                if (element instanceof Binding) {
                    this.boundKeys.add(((Binding)element).getKey());
                }
                if (!(element instanceof LinkedKeyBinding)) continue;
                LinkedKeyBinding linkedBind = (LinkedKeyBinding)element;
                this.linkedBindings.put((Object)linkedBind.getLinkedKey(), (Object)linkedBind);
            }
        }

        @Override
        public boolean test(Key key) {
            Key exposed = ModulesSupport.findExposed(key, this.linkedBindings, this.exposedKeys);
            if (exposed != null) {
                this.detected.put(key.getTypeLiteral().getRawType(), exposed);
            }
            return exposed != null;
        }
    }

    private static class AnalysisResult {
        public final List<Class<?>> extensions;
        public final List<Binding> removedBindings;
        public final Set<String> actuallyDisabledModules;

        AnalysisResult(List<Class<?>> extensions, List<Binding> removedBindings, Set<String> actuallyDisabledModules) {
            this.extensions = extensions;
            this.removedBindings = removedBindings;
            this.actuallyDisabledModules = actuallyDisabledModules;
        }
    }
}

