/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.inject.Binding;
import com.google.inject.Module;
import com.google.inject.ScopeAnnotation;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Scope;

public final class BindingUtils {
    public static final String JIT_MODULE = "JIT";

    private BindingUtils() {
    }

    public static List<String> getModules(Element element) {
        List<String> modules;
        if (element.getSource() instanceof ElementSource) {
            ElementSource source = (ElementSource)element.getSource();
            if (source.getOriginalElementSource() != null) {
                source = source.getOriginalElementSource();
            }
            modules = BindingUtils.replaceLambdaModuleClasses(source.getModuleClassNames());
        } else {
            modules = Collections.singletonList(JIT_MODULE);
        }
        return modules;
    }

    public static Class<? extends Module> getModuleClass(String name) {
        Class res;
        if (!JIT_MODULE.equals(name)) {
            try {
                res = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to resolve module class", e);
            }
        } else {
            res = Module.class;
        }
        return res;
    }

    public static Class<? extends Module> getTopDeclarationModule(Element element) {
        List<String> modulesStack = BindingUtils.getModules(element);
        return BindingUtils.getModuleClass(modulesStack.get(modulesStack.size() - 1));
    }

    public static String getDeclarationSource(Binding binding) {
        String res = "UNKNOWN";
        Object source = binding.getSource();
        if (source instanceof ElementSource) {
            ElementSource src = (ElementSource)source;
            StackTraceElement traceElement = null;
            if (src.getDeclaringSource() instanceof StackTraceElement) {
                traceElement = (StackTraceElement)src.getDeclaringSource();
            } else if (src.getDeclaringSource() instanceof Method) {
                traceElement = (StackTraceElement)StackTraceElements.forMember((Member)((Method)src.getDeclaringSource()));
            }
            if (traceElement != null) {
                res = traceElement.toString();
            }
        } else if (source instanceof Class) {
            res = ((Class)source).getName();
        }
        return res;
    }

    private static List<String> replaceLambdaModuleClasses(List<String> modules) {
        ArrayList<String> res;
        ArrayList<String> detected = null;
        for (String module : modules) {
            if (!module.contains("$$")) continue;
            try {
                Class.forName(module);
            }
            catch (ClassNotFoundException ex) {
                if (detected == null) {
                    detected = new ArrayList<String>();
                }
                detected.add(module);
            }
        }
        ArrayList<String> arrayList = res = detected == null ? modules : new ArrayList<String>(modules);
        if (detected != null) {
            res.removeAll(detected);
            if (res.isEmpty()) {
                res.add(Module.class.getName());
            }
        }
        return res;
    }

    public static Class<? extends Annotation> findScopingAnnotation(Class<?> type, boolean countGuiceSpecific) {
        Class<? extends Annotation> res = null;
        Class<?> jakartaScope = null;
        try {
            jakartaScope = Class.forName("jakarta.inject.Scope");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Annotation ann : type.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (annType.isAnnotationPresent(Scope.class) || jakartaScope != null && annType.isAnnotationPresent(jakartaScope)) {
                res = annType;
                break;
            }
            if (!countGuiceSpecific || !annType.isAnnotationPresent(ScopeAnnotation.class)) continue;
            res = annType;
            break;
        }
        return res;
    }
}

