/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ru.vyarus.dropwizard.guice.module.installer.util.InstanceUtils;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static <T> List<T> getProperty(String name, Map<String, String> aliases) {
        String prop = System.getProperty(name);
        List res = Collections.emptyList();
        if (prop != null) {
            Iterable classes = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)prop);
            try {
                res = PropertyUtils.toInstances(PropertyUtils.toClasses(classes, aliases));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to parse system property '%s' value: '%s'", name, prop), e);
            }
        }
        return res;
    }

    public static void setProperty(String name, Class<?> ... types) {
        String prop = Joiner.on((char)',').join(PropertyUtils.toStrings(Lists.newArrayList((Object[])types)));
        System.setProperty(name, prop);
    }

    private static List<String> toStrings(Iterable<Class> list) {
        ArrayList res = Lists.newArrayList();
        for (Class cls : list) {
            res.add(cls.getName());
        }
        return res;
    }

    private static <T> List<Class<T>> toClasses(Iterable<String> list, Map<String, String> aliases) throws Exception {
        ArrayList res = Lists.newArrayList();
        for (String cls : list) {
            res.add(Class.forName(aliases.getOrDefault(cls, cls)));
        }
        return res;
    }

    private static <T> List<T> toInstances(Iterable<Class<T>> list) {
        ArrayList res = Lists.newArrayList();
        for (Class<T> cls : list) {
            res.add(InstanceUtils.create(cls));
        }
        return res;
    }
}

