/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.env.listen;

import com.google.inject.Injector;
import io.dropwizard.testing.DropwizardTestSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.GuiceyTestSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.GuiceyExtensionsSupport;

public class EventContext {
    private final ExtensionContext context;
    private final boolean debug;

    public EventContext(ExtensionContext context, boolean debug) {
        this.context = context;
        this.debug = debug;
    }

    public ExtensionContext getJunitContext() {
        return this.context;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public DropwizardTestSupport<?> getSupport() {
        return GuiceyExtensionsSupport.lookupSupport(this.context).orElseThrow(() -> new IllegalStateException("Test support not found"));
    }

    public Injector getInjector() {
        return GuiceyExtensionsSupport.lookupInjector(this.context).orElseThrow(() -> new IllegalStateException("Injector not found"));
    }

    public <T> T getBean(Class<T> type) {
        return (T)this.getInjector().getInstance(type);
    }

    public ClientSupport getClient() {
        return GuiceyExtensionsSupport.lookupClient(this.context).orElseThrow(() -> new IllegalStateException("Client not found"));
    }

    public boolean isWebStarted() {
        return !(this.getSupport() instanceof GuiceyTestSupport);
    }
}

