/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.platform.commons.support.AnnotationSupport;
import ru.vyarus.dropwizard.guice.test.GuiceyTestSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.TestGuiceyApp;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.GuiceyExtensionsSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionBuilder;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.GuiceyTestTime;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.TestExtensionsTracker;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;
import ru.vyarus.dropwizard.guice.test.util.ReusableAppUtils;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public class TestGuiceyAppExtension
extends GuiceyExtensionsSupport {
    private Config config;

    public TestGuiceyAppExtension() {
        super(new TestExtensionsTracker());
    }

    private TestGuiceyAppExtension(Config config) {
        super(config.tracker);
        this.config = config;
    }

    public static <C extends Configuration> Builder<C> forApp(Class<? extends Application<C>> app) {
        return new Builder(app);
    }

    @Override
    protected ExtensionConfig getConfig(ExtensionContext context) {
        if (this.config == null) {
            Optional element = context.getElement();
            TestGuiceyApp ann = AnnotationSupport.findAnnotation((Optional)element, TestGuiceyApp.class).orElse(null);
            Preconditions.checkNotNull((Object)ann, (String)"%s annotation not declared: can't work without configuration, so either use annotation or extension with @%s for manual configuration", (Object)TestGuiceyApp.class.getSimpleName(), (Object)RegisterExtension.class.getSimpleName());
            this.config = Config.parse(ann, this.tracker);
            if (this.config.reuseApp) {
                ReusableAppUtils.registerAnnotation(context.getRequiredTestClass(), ann, this.config);
            }
        }
        if (this.config.reuseApp && this.config.reuseSource == null) {
            ReusableAppUtils.registerField(context.getRequiredTestClass(), this, this.config);
        }
        return this.config;
    }

    @Override
    protected DropwizardTestSupport<?> prepareTestSupport(String configPrefix, ExtensionContext context, List<TestEnvironmentSetup> setups) {
        this.config.extensions.addAll(setups);
        TestSetupUtils.executeSetup(this.config, context, this.listeners);
        Stopwatch timer = Stopwatch.createStarted();
        HooksUtil.register(this.config.hooks);
        this.tracker.performanceTrack(GuiceyTestTime.HooksRegistration, timer.elapsed());
        timer.reset().start();
        DropwizardTestSupport res = this.create(configPrefix, this.config.app, this.config.configPath, context);
        this.tracker.performanceTrack(GuiceyTestTime.DropwizardTestSupport, timer.elapsed());
        return res;
    }

    private <C extends Configuration> DropwizardTestSupport<C> create(String configPrefix, Class<? extends Application> app, String configPath, ExtensionContext context) {
        Object manualConfig = this.config.getConfiguration(this.config.configPath);
        GuiceyTestSupport support = manualConfig == null ? new GuiceyTestSupport(app, configPath, configPrefix, this.buildConfigOverrides(configPrefix, context)) : new GuiceyTestSupport(app, manualConfig);
        support.configModifiers(this.config.configModifiers);
        if (!this.config.managedLifecycle) {
            support.disableManagedLifecycle();
        }
        return support;
    }

    private <T extends ConfigOverride> ConfigOverride[] buildConfigOverrides(String prefix, ExtensionContext context) {
        ConfigOverride[] overrides = ConfigOverrideUtils.convert(prefix, this.config.configOverrides);
        return this.config.configOverrideObjects.isEmpty() ? overrides : ConfigOverrideUtils.merge(overrides, ConfigOverrideUtils.prepareExtensionOverrides(ConfigOverrideUtils.prepareOverrides(prefix, this.config.configOverrideObjects), context));
    }

    private static class Config
    extends ExtensionConfig {
        Class<? extends Application> app;
        String configPath = "";
        boolean managedLifecycle = true;

        Config() {
            super(new TestExtensionsTracker());
        }

        Config(TestExtensionsTracker tracker) {
            super(tracker);
        }

        final void extensionInstances(TestEnvironmentSetup ... exts) {
            Collections.addAll(this.extensions, exts);
            this.tracker.extensionInstances(exts);
        }

        @SafeVarargs
        final void extensionClasses(Class<? extends TestEnvironmentSetup> ... exts) {
            this.extensions.addAll(TestSetupUtils.create(exts));
            this.tracker.extensionClasses(exts);
        }

        static Config parse(TestGuiceyApp ann, TestExtensionsTracker tracker) {
            Config res = new Config(tracker);
            res.app = ann.value();
            res.configPath = ann.config();
            res.configOverrides = ann.configOverride();
            res.configModifiersFromAnnotation(ann.annotationType(), ann.configModifiers());
            res.hooksFromAnnotation(ann.annotationType(), ann.hooks());
            res.extensionsFromAnnotation(ann.annotationType(), ann.setup());
            res.injectOnce = ann.injectOnce();
            res.tracker.debug = ann.debug();
            res.reuseApp = ann.reuseApplication();
            res.defaultExtensionsEnabled = ann.useDefaultExtensions();
            res.clientFactory(ann.clientFactory());
            res.managedLifecycle = ann.managedLifecycle();
            return res;
        }
    }

    public static class Builder<C extends Configuration>
    extends ExtensionBuilder<C, Builder<C>, Config> {
        public Builder(Class<? extends Application<C>> app) {
            super(new Config());
            ((Config)this.cfg).app = (Class)Preconditions.checkNotNull(app, (Object)"Application class must be provided");
        }

        public Builder<C> config(String configPath) {
            ((Config)this.cfg).configPath = configPath;
            return this;
        }

        @SafeVarargs
        public final Builder<C> setup(Class<? extends TestEnvironmentSetup> ... support) {
            ((Config)this.cfg).extensionClasses(support);
            return this;
        }

        public Builder<C> setup(TestEnvironmentSetup ... support) {
            ((Config)this.cfg).extensionInstances(support);
            return this;
        }

        public Builder<C> disableManagedLifecycle() {
            ((Config)this.cfg).managedLifecycle = false;
            return this;
        }

        public TestGuiceyAppExtension create() {
            return new TestGuiceyAppExtension((Config)this.cfg);
        }
    }
}

