/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.track;

import com.google.common.base.Preconditions;
import com.google.inject.Binding;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedTestFieldSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.track.TrackBean;
import ru.vyarus.dropwizard.guice.test.track.Tracker;
import ru.vyarus.dropwizard.guice.test.track.TrackersHook;
import ru.vyarus.dropwizard.guice.test.track.stat.TrackerStats;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public class TrackerFieldsSupport
extends AnnotatedTestFieldSetup<TrackBean, Tracker> {
    private static final String TEST_TRACKER_FIELDS = "TEST_TRACKER_FIELDS";
    private static final String FIELD_TRACKER = "FIELD_TRACKER";
    private static final String DOUBLE_NL = ":\n\n";
    private final TrackersHook hook = new TrackersHook();

    public TrackerFieldsSupport() {
        super(TrackBean.class, Tracker.class, TEST_TRACKER_FIELDS);
    }

    @Override
    protected void fieldDetected(ExtensionContext context, AnnotatedField<TrackBean, Tracker> field) {
        Class<?> type = field.getTypeParameters().get(0);
        if (type == Object.class) {
            throw new IllegalStateException(this.getDeclarationErrorPrefix(field) + "tracked service must be declared as a tracker object generic: Tracker<Bean>");
        }
    }

    @Override
    protected void registerHooks(TestExtension extension) {
        extension.hooks(this.hook);
    }

    @Override
    protected <K> void initializeField(AnnotatedField<TrackBean, Tracker> field, Tracker userValue) {
        Preconditions.checkState((userValue == null ? 1 : 0) != 0, (Object)(this.getDeclarationErrorPrefix(field) + "tracker instance can't be provided manually"));
        Class<?> type = field.getTypeParameters().get(0);
        TrackBean ann = field.getAnnotation();
        Tracker<?> tracker = this.hook.track(type).trace(ann.trace()).slowMethods(ann.slowMethods(), ann.slowMethodsUnit()).keepRawObjects(ann.keepRawObjects()).maxStringLength(ann.maxStringLength()).add();
        field.setCustomData(FIELD_TRACKER, tracker);
    }

    @Override
    protected void beforeValueInjection(EventContext context, AnnotatedField<TrackBean, Tracker> field) {
        Tracker tracker = (Tracker)Preconditions.checkNotNull((Object)((Tracker)field.getCustomData(FIELD_TRACKER)));
        Binding binding = context.getInjector().getBinding(tracker.getType());
        Preconditions.checkState((!this.isInstanceBinding(binding) ? 1 : 0) != 0, (String)(this.getDeclarationErrorPrefix(field) + "target bean '%s' bound by instance and so can't be tracked"), (Object)tracker.getType().getSimpleName());
    }

    @Override
    protected Tracker injectFieldValue(EventContext context, AnnotatedField<TrackBean, Tracker> field) {
        return (Tracker)field.getCustomData(FIELD_TRACKER);
    }

    @Override
    protected void report(EventContext context, List<AnnotatedField<TrackBean, Tracker>> annotatedFields) {
        StringBuilder report = new StringBuilder("\nApplied trackers (@").append(TrackBean.class.getSimpleName()).append(") on ").append(this.setupContextName).append(DOUBLE_NL);
        this.fields.forEach(field -> report.append(String.format("\t%-30s %-20s%n", "#" + field.getField().getName(), RenderUtils.renderClassLine(((Tracker)field.getCustomData(FIELD_TRACKER)).getType()))));
        System.out.println(report);
    }

    @Override
    protected void beforeTest(EventContext context, AnnotatedField<TrackBean, Tracker> field, Tracker value) {
    }

    @Override
    protected void afterTest(EventContext context, AnnotatedField<TrackBean, Tracker> field, Tracker value) {
        Tracker tracker;
        TrackBean ann = field.getAnnotation();
        if (ann.printSummary() && !(tracker = (Tracker)field.getCustomData(FIELD_TRACKER)).isEmpty()) {
            System.out.println(PrintUtils.getPerformanceReportSeparator(context.getJunitContext()) + "Tracker<" + tracker.getType().getSimpleName() + "> stats (sorted by median) for " + TestSetupUtils.getContextTestName(context.getJunitContext()) + DOUBLE_NL + tracker.getStats().render());
        }
        if (ann.autoReset()) {
            value.clear();
        }
    }

    @Override
    public void afterEach(EventContext context) {
        Tracker[] trackers;
        if (context.isDebug() && (trackers = (Tracker[])this.fields.stream().map(field -> (Tracker)field.getCustomData(FIELD_TRACKER)).toArray(Tracker[]::new)).length > 0) {
            System.out.println(PrintUtils.getPerformanceReportSeparator(context.getJunitContext()) + "Trackers stats (sorted by median) for " + TestSetupUtils.getContextTestName(context.getJunitContext()) + DOUBLE_NL + new TrackerStats(trackers).render());
        }
        super.afterEach(context);
    }
}

