/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.rest.support;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.core.setup.Environment;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.inmemory.InMemoryTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import ru.vyarus.dropwizard.guice.test.client.DefaultTestClientFactory;
import ru.vyarus.dropwizard.guice.test.rest.TestContainerPolicy;

public class GuiceyJerseyTest
extends JerseyTest {
    private static Environment environment;
    private static TestContainerPolicy policy;
    private final boolean logRequests;
    private URI rootUri;

    protected GuiceyJerseyTest(boolean logRequests) {
        this.logRequests = logRequests;
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"EI_EXPOSE_STATIC_REP2"})
    public static GuiceyJerseyTest create(Environment environment, TestContainerPolicy policy, boolean logRequests) {
        Class<GuiceyJerseyTest> clazz = GuiceyJerseyTest.class;
        synchronized (GuiceyJerseyTest.class) {
            GuiceyJerseyTest.environment = environment;
            GuiceyJerseyTest.policy = policy;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new GuiceyJerseyTest(logRequests);
        }
    }

    public URI getRootUri() {
        return (URI)Preconditions.checkNotNull((Object)this.rootUri);
    }

    public TestContainerFactory getTestContainerFactory() {
        TestContainerFactory res;
        switch (policy) {
            case DEFAULT: {
                res = super.getTestContainerFactory();
                break;
            }
            case IN_MEMORY: {
                res = new InMemoryTestContainerFactory();
                break;
            }
            case GRIZZLY: {
                res = StreamSupport.stream(ServiceFinder.find(TestContainerFactory.class).spliterator(), false).filter(factory -> "org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory".equals(factory.getClass().getName())).findFirst().orElseThrow(() -> new IllegalStateException("org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory is not available in classpath. Add `org.glassfish.jersey.test-framework.providers:jersey-test-framework-provider-grizzly2` dependency (version managed by dropwizard BOM)"));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported policy: " + policy);
            }
        }
        return res;
    }

    protected URI getBaseUri() {
        URI res;
        this.forceSet("jersey.config.test.container.port", "0");
        this.rootUri = res = super.getBaseUri();
        return res;
    }

    protected DeploymentContext configureDeployment() {
        return ServletDeploymentContext.builder((Application)environment.jersey().getResourceConfig()).build();
    }

    protected void configureClient(ClientConfig clientConfig) {
        if (this.logRequests) {
            clientConfig.register((Object)LoggingFeature.builder().withLogger((Logger)new DefaultTestClientFactory.ConsoleLogger()).verbosity(LoggingFeature.Verbosity.PAYLOAD_TEXT).level(Level.INFO).build());
        }
        clientConfig.property("jersey.config.client.connectTimeout", (Object)1000);
        clientConfig.property("jersey.config.client.readTimeout", (Object)5000);
        clientConfig.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        try {
            Class<?> cls = Class.forName("org.glassfish.jersey.media.multipart.MultiPartFeature");
            clientConfig.register(cls);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

