/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.track;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.inject.matcher.Matchers;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.track.Tracker;
import ru.vyarus.dropwizard.guice.test.track.TrackerConfig;
import ru.vyarus.dropwizard.guice.test.track.TrackerProxy;

public class TrackersHook
implements GuiceyConfigurationHook {
    private final MetricRegistry metrics = new MetricRegistry();
    private final Map<Class<?>, TrackerProxy<?>> trackers = new HashMap();
    private boolean initialized;

    @Override
    public void configure(GuiceBundle.Builder builder) throws Exception {
        if (!this.trackers.isEmpty()) {
            builder.modulesOverride(binder -> this.trackers.forEach((type, proxy) -> binder.bindInterceptor(Matchers.only((Object)type), Matchers.any(), new MethodInterceptor[]{proxy})));
        }
        this.initialized = true;
    }

    public <T> Builder<T> track(Class<T> type) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Too late. Trackers already applied.");
        Preconditions.checkState((!this.trackers.containsKey(type) ? 1 : 0) != 0, (String)"Tracker object for type %s is already registered.", (Object)type.getSimpleName());
        return new Builder<T>(type);
    }

    public <T> Tracker<T> getTracker(Class<T> type) {
        return ((TrackerProxy)Preconditions.checkNotNull(this.trackers.get(type), (String)"Tracker not registered for type %s", (Object)type.getSimpleName())).getTracker();
    }

    public void resetTrackers() {
        this.trackers.values().forEach(proxy -> proxy.getTracker().clear());
    }

    public class Builder<T> {
        private final Class<T> type;
        private final TrackerConfig config = new TrackerConfig();

        public Builder(Class<T> type) {
            this.type = type;
        }

        public Builder<T> trace(boolean trace) {
            this.config.setTrace(trace);
            return this;
        }

        public Builder<T> slowMethods(long maxTime, ChronoUnit unit) {
            this.config.setSlowMethods(maxTime);
            this.config.setSlowMethodsUnit(unit);
            return this;
        }

        public Builder<T> disableSlowMethodsLogging() {
            this.config.setSlowMethods(0L);
            return this;
        }

        public Builder<T> keepRawObjects(boolean keepRawObjects) {
            this.config.setKeepRawObjects(keepRawObjects);
            return this;
        }

        public Builder<T> maxStringLength(int maxStringLength) {
            this.config.setMaxStringLength(maxStringLength);
            return this;
        }

        public Tracker<T> add() {
            TrackerProxy<T> proxy = new TrackerProxy<T>(this.type, this.config, TrackersHook.this.metrics);
            TrackersHook.this.trackers.put(this.type, proxy);
            return proxy.getTracker();
        }
    }
}

