/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Predicate;

public final class ClassFilters {
    private ClassFilters() {
    }

    @SafeVarargs
    public static Predicate<Class<?>> annotated(Class<? extends Annotation> ... annotation) {
        return type -> Arrays.stream(annotation).anyMatch(type::isAnnotationPresent);
    }

    public static Predicate<Class<?>> inPackages(String ... packages) {
        return type -> Arrays.stream(packages).anyMatch(pkg -> type.getName().startsWith((String)pkg));
    }

    public static Predicate<Class<?>> declaredIn(Class<?> ... baseClasses) {
        return type -> type.getDeclaringClass() != null && Arrays.stream(baseClasses).anyMatch(base -> type.getDeclaringClass().equals(base));
    }

    @SafeVarargs
    public static Predicate<Class<?>> ignoreAnnotated(Class<? extends Annotation> ... annotation) {
        return ClassFilters.annotated(annotation).negate();
    }

    public static Predicate<Class<?>> ignorePackages(String ... packages) {
        return ClassFilters.inPackages(packages).negate();
    }

    public static Predicate<Class<?>> ignoreDeclaredIn(Class<?> ... baseClasses) {
        return ClassFilters.declaredIn(baseClasses).negate();
    }
}

