/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class PrintUtils {
    private static final String DURATION_FORMATION = "%2.3f %s";
    private static final String VALUE_FORMATION = "%2.3f";

    private PrintUtils() {
    }

    public static String identity(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    public static String[] toStringArguments(Object[] args, int maxLength) {
        String[] arguments = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            arguments[i] = PrintUtils.toStringValue(args[i], maxLength);
        }
        return arguments;
    }

    public static String toStringValue(Object value, int maxLength) {
        Object res;
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            res = (String)value;
            if (((String)res).length() > maxLength) {
                res = ((String)res).substring(0, maxLength) + "...";
            }
        } else {
            res = value.getClass().isPrimitive() || value instanceof Number || value instanceof Boolean ? value.toString() : (value instanceof Collection ? PrintUtils.toStringCollection((Collection)value, maxLength) : (value.getClass().isArray() ? PrintUtils.toStringArray((Object[])value, maxLength) : value.getClass().getSimpleName() + "@" + PrintUtils.identity(value)));
        }
        return res;
    }

    public static String renderTime(Duration overall, Duration increase) {
        return overall == null ? "--" : PrintUtils.ms(overall) + (String)(increase != null && increase.toNanos() > 0L ? " ( + " + PrintUtils.ms(increase) + ")" : "");
    }

    public static String ms(Duration duration) {
        return PrintUtils.ms(duration.toNanos());
    }

    public static String ms(long nanos) {
        long millis = Math.round((double)nanos / 1000000.0);
        Object res = millis > 10L ? millis + " ms" : (nanos < 10L ? "0.00 ms" : (nanos < 100L ? PrintUtils.formatMs(nanos, 5) : (nanos < 1000L ? PrintUtils.formatMs(nanos, 4) : (nanos < 10000L ? PrintUtils.formatMs(nanos, 3) : PrintUtils.formatMs(nanos, 2)))));
        return res;
    }

    public static String formatMs(long nanos, int precision) {
        String format = "%." + precision + "f ms";
        return String.format(format, new BigDecimal(nanos).divide(BigDecimal.valueOf(1000000L), precision, RoundingMode.HALF_UP).doubleValue());
    }

    public static String formatMetric(double time) {
        return PrintUtils.formatMetric(time, TimeUnit.MILLISECONDS);
    }

    public static String formatMetric(double time, TimeUnit unit) {
        if (unit == null) {
            return String.format(VALUE_FORMATION, time);
        }
        return String.format(DURATION_FORMATION, PrintUtils.convertDuration(time, unit), PrintUtils.toStringUnit(unit));
    }

    public static String getPerformanceReportSeparator(ExtensionContext context) {
        Object inst = "---------------------------------\n";
        if (context.getTestInstance().isPresent()) {
            inst = "/ test instance = " + PrintUtils.identity(context.getTestInstance().get()) + " /\n";
        }
        return "\n\\\\\\------------------------------------------------------------" + (String)inst;
    }

    private static String toStringCollection(Collection<?> list, int maxLength) {
        StringBuilder builder = new StringBuilder("(").append(list.size()).append(")[");
        if (!list.isEmpty()) {
            builder.append(' ');
        }
        Iterator<?> it = list.iterator();
        for (int cnt = 0; it.hasNext() && cnt < 10; ++cnt) {
            builder.append(cnt > 0 ? "," : "").append(PrintUtils.toStringValue(it.next(), maxLength));
        }
        if (list.size() > 10) {
            builder.append(",...");
        }
        if (!list.isEmpty()) {
            builder.append(' ');
        }
        return builder.append(']').toString();
    }

    private static String toStringArray(Object[] array, int maxLength) {
        return PrintUtils.toStringCollection(Arrays.asList(array), maxLength);
    }

    private static String toStringUnit(TimeUnit unit) {
        String res;
        switch (unit) {
            case NANOSECONDS: {
                res = "ns";
                break;
            }
            case MICROSECONDS: {
                res = "\u03bcs";
                break;
            }
            case MILLISECONDS: {
                res = "ms";
                break;
            }
            case SECONDS: {
                res = "s";
                break;
            }
            case MINUTES: {
                res = "m";
                break;
            }
            case HOURS: {
                res = "h";
                break;
            }
            case DAYS: {
                res = "d";
                break;
            }
            default: {
                res = unit.toString().toLowerCase();
            }
        }
        return res;
    }

    private static double convertDuration(double duration, TimeUnit durationUnit) {
        double durationFactor = 1.0 / (double)durationUnit.toNanos(1L);
        return duration * durationFactor;
    }
}

