/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.module.installer.util.InstanceUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.ListenersSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.GuiceyTestTime;

public final class TestSetupUtils {
    private TestSetupUtils() {
    }

    public static TestEnvironmentSetup[] lookup() {
        return (TestEnvironmentSetup[])Lists.newArrayList(ServiceLoader.load(TestEnvironmentSetup.class)).toArray(TestEnvironmentSetup[]::new);
    }

    @SafeVarargs
    public static List<TestEnvironmentSetup> create(Class<? extends TestEnvironmentSetup> ... extensions) {
        ArrayList<TestEnvironmentSetup> res = new ArrayList<TestEnvironmentSetup>();
        for (Class<? extends TestEnvironmentSetup> ext : extensions) {
            try {
                res.add(InstanceUtils.create(ext));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate test support object: " + ext.getSimpleName(), e);
            }
        }
        return res;
    }

    public static void executeSetup(ExtensionConfig config, ExtensionContext context, ListenersSupport listeners) {
        if (!config.extensions.isEmpty()) {
            Stopwatch timer = Stopwatch.createStarted();
            TestExtension builder = new TestExtension(config, context, listeners);
            ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{TestEnvironmentSetup.class}));
            for (TestEnvironmentSetup support : config.extensions) {
                Object res = TestSetupUtils.setup(support, config, builder);
                if (!(res instanceof AutoCloseable) && !(res instanceof ExtensionContext.Store.CloseableResource)) continue;
                store.put(support.getClass(), (Object)ClosableWrapper.create(res));
            }
            config.tracker.performanceTrack(GuiceyTestTime.SetupObjectsExecution, timer.elapsed());
        }
    }

    public static String getContextTestName(ExtensionContext context) {
        Object res = context.getDisplayName();
        if (context.getTestMethod().isPresent()) {
            res = ((ExtensionContext)context.getParent().get()).getDisplayName() + "#" + (String)res;
        }
        return res;
    }

    private static Object setup(TestEnvironmentSetup support, ExtensionConfig config, TestExtension builder) {
        config.tracker.setContextSetupObject(support.getClass());
        try {
            Object res = support.setup(builder);
            config.tracker.setContextSetupObject(null);
            return res;
        }
        catch (Exception ex) {
            Throwables.throwIfUnchecked((Throwable)ex);
            throw new IllegalStateException("Failed to run test setup object", ex);
        }
    }

    public static class ClosableWrapper
    implements ExtensionContext.Store.CloseableResource {
        private final AutoCloseable obj;

        public ClosableWrapper(AutoCloseable obj) {
            this.obj = obj;
        }

        public void close() throws Throwable {
            this.obj.close();
        }

        public static ExtensionContext.Store.CloseableResource create(Object obj) {
            return obj instanceof ExtensionContext.Store.CloseableResource ? (ExtensionContext.Store.CloseableResource)obj : new ClosableWrapper((AutoCloseable)obj);
        }
    }
}

