/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey.debug.service;

import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;
import ru.vyarus.dropwizard.guice.module.jersey.debug.service.WrongContextException;

@Singleton
public class ContextDebugService {
    private final Provider<ExtensionsHolder> holder;
    private final Options options;
    private final List<Class<?>> hkManaged = Lists.newArrayList();
    private final List<Class<?>> guiceManaged = Lists.newArrayList();
    private final Lock lock = new ReentrantLock();
    private List<Class<?>> managedTypes;

    @Inject
    public ContextDebugService(Provider<ExtensionsHolder> holder, Options options) {
        this.holder = holder;
        this.options = options;
    }

    public List<Class<?>> getManagedTypes() {
        if (this.managedTypes == null) {
            this.lock.lock();
            try {
                if (this.managedTypes == null) {
                    this.managedTypes = this.buildManagedTypes();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.managedTypes;
    }

    public void hkManage(Class<?> type) {
        if (!JerseyBinding.isJerseyManaged(type, (Boolean)this.options.get(InstallersOptions.JerseyExtensionsManagedByGuice))) {
            throw new WrongContextException("HK2 creates service %s which must be managed by guice.", type.getName());
        }
        this.hkManaged.add(type);
    }

    public void guiceManage(Class<?> type) {
        if (JerseyBinding.isJerseyManaged(type, (Boolean)this.options.get(InstallersOptions.JerseyExtensionsManagedByGuice))) {
            throw new WrongContextException("Guice creates service %s which must be managed by HK2.", type.getName());
        }
        this.guiceManaged.add(type);
    }

    public List<Class<?>> getHkManaged() {
        return Lists.newArrayList(this.hkManaged);
    }

    public List<Class<?>> getGuiceManaged() {
        return Lists.newArrayList(this.guiceManaged);
    }

    private List<Class<?>> buildManagedTypes() {
        ArrayList managedTypes = Lists.newArrayList();
        for (Class<? extends FeatureInstaller> installer : ((ExtensionsHolder)this.holder.get()).getInstallerTypes()) {
            List<Class<?>> features;
            if (!JerseyInstaller.class.isAssignableFrom(installer) || (features = ((ExtensionsHolder)this.holder.get()).getExtensions(installer)) == null) continue;
            managedTypes.addAll(features);
        }
        return managedTypes;
    }
}

