/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.builder;

import com.google.common.base.MoreObjects;
import com.google.inject.Injector;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.DropwizardTestSupport;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.vyarus.dropwizard.guice.test.GuiceyTestSupport;
import ru.vyarus.dropwizard.guice.test.TestSupport;
import ru.vyarus.dropwizard.guice.test.builder.BaseBuilder;
import ru.vyarus.dropwizard.guice.test.client.DefaultTestClientFactory;
import ru.vyarus.dropwizard.guice.test.client.TestClientFactory;
import ru.vyarus.dropwizard.guice.test.util.RandomPortsListener;
import ru.vyarus.dropwizard.guice.test.util.RunResult;

public class TestSupportBuilder<C extends Configuration>
extends BaseBuilder<C, TestSupportBuilder<C>> {
    private boolean randomPorts;
    private final List<TestListener<C>> listeners = new ArrayList<TestListener<C>>();
    private TestClientFactory factory = new DefaultTestClientFactory();

    public TestSupportBuilder(Class<? extends Application<C>> app) {
        super(app);
    }

    public TestSupportBuilder<C> randomPorts() {
        return this.randomPorts(true);
    }

    public TestSupportBuilder<C> randomPorts(boolean randomPorts) {
        this.randomPorts = randomPorts;
        return this;
    }

    public TestSupportBuilder<C> clientFactory(TestClientFactory factory) {
        this.factory = factory;
        return this;
    }

    public TestSupportBuilder<C> listen(TestListener<C> listener) {
        this.listeners.add(listener);
        return this;
    }

    public GuiceyTestSupport<C> buildCore() {
        if (!this.listeners.isEmpty()) {
            throw new IllegalStateException("Listeners could be used only with run* methods.");
        }
        return this.buildCoreInternal();
    }

    public DropwizardTestSupport<C> buildWeb() {
        if (!this.listeners.isEmpty()) {
            throw new IllegalStateException("Listeners could be used only with run* methods.");
        }
        return this.buildWebInternal();
    }

    public RunResult<C> runCore() throws Exception {
        return this.runCore(injector -> new RunResult(TestSupport.getContext(), injector));
    }

    public <T> T runCore(@Nullable TestSupport.RunCallback<T> action) throws Exception {
        return this.run(this.buildCoreInternal(), action);
    }

    public RunResult<C> runWeb() throws Exception {
        return this.runWeb(injector -> new RunResult(TestSupport.getContext(), injector));
    }

    public <T> T runWeb(@Nullable TestSupport.RunCallback<T> action) throws Exception {
        return this.run(this.buildWebInternal(), action);
    }

    private GuiceyTestSupport<C> buildCoreInternal() {
        GuiceyTestSupport<Object> support;
        if (this.configObject != null) {
            if (this.configPath != null || !this.configOverrides.isEmpty() || this.configSourceProvider != null) {
                throw new IllegalStateException("Configuration object can't be used together with yaml configuration");
            }
            support = new GuiceyTestSupport<Configuration>(this.app, this.configObject);
        } else {
            String prefix = (String)MoreObjects.firstNonNull((Object)this.propertyPrefix, (Object)"dw.");
            support = new GuiceyTestSupport(this.app, this.configPath, this.configSourceProvider, prefix, this.prepareOverrides(prefix));
        }
        if (this.randomPorts) {
            support.addListener(new RandomPortsListener());
        }
        return support;
    }

    private DropwizardTestSupport<C> buildWebInternal() {
        DropwizardTestSupport support;
        if (this.configObject != null) {
            if (this.configPath != null || !this.configOverrides.isEmpty() || this.configSourceProvider != null) {
                throw new IllegalStateException("Configuration object can't be used together with yaml configuration");
            }
            support = new DropwizardTestSupport(this.app, this.configObject);
        } else {
            String prefix = (String)MoreObjects.firstNonNull((Object)this.propertyPrefix, (Object)"dw.");
            support = new DropwizardTestSupport(this.app, this.configPath, this.configSourceProvider, prefix, this.prepareOverrides(prefix));
        }
        if (this.randomPorts) {
            support.addListener(new RandomPortsListener());
        }
        return support;
    }

    private <T> T run(DropwizardTestSupport<C> support, @Nullable TestSupport.RunCallback<T> callback) throws Exception {
        return this.runWithListeners(support, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runWithListeners(DropwizardTestSupport<C> support, @Nullable TestSupport.RunCallback<T> callback) throws Exception {
        for (TestListener<C> testListener : this.listeners) {
            testListener.setup(support);
        }
        try {
            Object object = TestSupport.run(support, this.factory, injector -> {
                for (TestListener<C> testListener : this.listeners) {
                    testListener.run(support, injector);
                }
                try {
                    Iterator<TestListener<C>> iterator = callback != null ? callback.run(injector) : null;
                    return iterator;
                }
                finally {
                    for (TestListener<C> listener : this.listeners) {
                        listener.stop(support, injector);
                    }
                }
            });
            return (T)object;
        }
        finally {
            for (TestListener<C> listener : this.listeners) {
                listener.cleanup(support);
            }
        }
    }

    public static interface TestListener<C extends Configuration> {
        default public void setup(DropwizardTestSupport<C> support) throws Exception {
        }

        default public void run(DropwizardTestSupport<C> support, Injector injector) throws Exception {
        }

        default public void stop(DropwizardTestSupport<C> support, Injector injector) throws Exception {
        }

        default public void cleanup(DropwizardTestSupport<C> support) throws Exception {
        }
    }
}

