/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.builder;

import com.google.common.base.Preconditions;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.DropwizardTestSupport;
import jakarta.annotation.Nullable;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.TestSupport;
import ru.vyarus.dropwizard.guice.test.client.TestClientFactory;

public final class TestSupportHolder {
    private static final ThreadLocal<State> SUPPORT = new ThreadLocal();

    private TestSupportHolder() {
    }

    public static void setContext(DropwizardTestSupport<?> support, @Nullable TestClientFactory clientFactory) {
        TestSupportHolder.setContext(support, TestSupport.webClient(support, clientFactory));
        Preconditions.checkNotNull(support, (Object)"Support object can't be null");
        SUPPORT.set(new State(support, TestSupport.webClient(support, clientFactory), true));
    }

    public static void setContext(DropwizardTestSupport<?> support, @Nullable ClientSupport client) {
        Preconditions.checkNotNull(support, (Object)"Support object can't be null");
        boolean manageClient = client == null;
        SUPPORT.set(new State(support, manageClient ? TestSupport.webClient(support) : client, manageClient));
    }

    public static <C extends Configuration> DropwizardTestSupport<C> getContext() {
        Preconditions.checkState((boolean)TestSupportHolder.isContextSet(), (Object)"Test support object not bound in thread");
        return SUPPORT.get().getSupport();
    }

    public static boolean isContextSet() {
        return SUPPORT.get() != null;
    }

    public static ClientSupport getClient() {
        Preconditions.checkState((boolean)TestSupportHolder.isContextSet(), (Object)"Test support object not bound in thread");
        return SUPPORT.get().getClient();
    }

    public static void reset() {
        State state = SUPPORT.get();
        if (state != null) {
            SUPPORT.remove();
            if (state.isManageClient()) {
                try {
                    state.getClient().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class State {
        private final DropwizardTestSupport support;
        private final ClientSupport client;
        private final boolean manageClient;

        State(DropwizardTestSupport support, ClientSupport client, boolean manageClient) {
            this.support = support;
            this.client = client;
            this.manageClient = manageClient;
        }

        public DropwizardTestSupport getSupport() {
            return this.support;
        }

        public ClientSupport getClient() {
            return this.client;
        }

        public boolean isManageClient() {
            return this.manageClient;
        }
    }
}

