/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor;

import com.google.inject.Binding;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.InterceptorBinding;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProvisionListenerBinding;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeListenerBinding;
import java.util.Collections;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.BindingDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.DeclarationType;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor.GuiceBindingVisitor;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor.PrivateModuleException;

public class GuiceElementVisitor
extends DefaultElementVisitor<BindingDeclaration> {
    private static final GuiceBindingVisitor BINDING_VISITOR = new GuiceBindingVisitor();

    public <T> BindingDeclaration visit(Binding<T> binding) {
        return (BindingDeclaration)binding.acceptTargetVisitor((BindingTargetVisitor)BINDING_VISITOR);
    }

    public BindingDeclaration visit(InterceptorBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.Aop, binding);
        res.setSpecial(binding.getInterceptors());
        return res;
    }

    public BindingDeclaration visit(ScopeBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.Scope, binding);
        res.setScope(binding.getAnnotationType());
        return res;
    }

    public BindingDeclaration visit(TypeConverterBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.TypeConverter, binding);
        res.setSpecial(Collections.singletonList(binding.getTypeConverter()));
        return res;
    }

    public BindingDeclaration visit(PrivateElements elements) {
        throw new PrivateModuleException(elements);
    }

    public BindingDeclaration visit(TypeListenerBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.TypeListener, binding);
        res.setSpecial(Collections.singletonList(binding.getListener()));
        return res;
    }

    public BindingDeclaration visit(ProvisionListenerBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.ProvisionListener, binding);
        res.setSpecial(binding.getListeners());
        return res;
    }

    protected BindingDeclaration visitOther(Element element) {
        return null;
    }
}

