/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.jersey.util;

import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.GenericsContext;

public final class ProviderRenderUtil {
    private static final String SIMPLE_FORMAT = "%s";
    private static final String SINGLE_GENERIC_FORMAT = "%-30s %s";
    private static final String DOUBLE_GENERICS_FORMAT = "%-15s -> %-15s %s";
    private static final String INJECTION_FORMAT = "@%-30s %s";
    private static final Map<Class, ExtDescriptor> DESCRIPTORS = ImmutableMap.builder().put(Supplier.class, (Object)new ExtDescriptor("Suppliers", "%-30s %s", 1)).put(Function.class, (Object)new ExtDescriptor("Functions", "%-15s -> %-15s %s", 2)).put(ExceptionMapper.class, (Object)new ExtDescriptor("Exception mappers", "%-30s %s", 1)).put(ParamConverterProvider.class, (Object)new ExtDescriptor("Param converters", "%s", 0)).put(ContextResolver.class, (Object)new ExtDescriptor("Context resolvers", "%-30s %s", 1)).put(MessageBodyReader.class, (Object)new ExtDescriptor("Message body readers", "%-30s %s", 1)).put(MessageBodyWriter.class, (Object)new ExtDescriptor("Message body writers", "%-30s %s", 1)).put(ReaderInterceptor.class, (Object)new ExtDescriptor("Reader interceptors", "%s", 0)).put(WriterInterceptor.class, (Object)new ExtDescriptor("Writer interceptors", "%s", 0)).put(ContainerRequestFilter.class, (Object)new ExtDescriptor("Container request filters", "%s", 0)).put(ContainerResponseFilter.class, (Object)new ExtDescriptor("Container response filters", "%s", 0)).put(DynamicFeature.class, (Object)new ExtDescriptor("Dynamic features", "%s", 0)).put(InjectionResolver.class, (Object)new ExtDescriptor("Injection resolvers", "@%-30s %s", 1)).put(ValueParamProvider.class, (Object)new ExtDescriptor("Param value providers", "%s", 0)).put(ApplicationEventListener.class, (Object)new ExtDescriptor("Application event listeners", "%s", 0)).put(ModelProcessor.class, (Object)new ExtDescriptor("Model processors", "%s", 0)).build();

    private ProviderRenderUtil() {
    }

    public static List<Class> detectProviderTypes(Class<?> provider) {
        ArrayList<Class> res = new ArrayList<Class>();
        boolean recognized = false;
        for (Map.Entry<Class, ExtDescriptor> entry : DESCRIPTORS.entrySet()) {
            Class ext = entry.getKey();
            if (!ext.isAssignableFrom(provider)) continue;
            recognized = true;
            res.add(ext);
        }
        if (!recognized) {
            res.add(Object.class);
        }
        return res;
    }

    public static String render(Class<?> ext, Class provider, boolean isHkManaged, boolean isLazy) {
        if (ext.equals(MessageBodyWriter.class) || ext.equals(MessageBodyReader.class)) {
            return ProviderRenderUtil.renderMessageReaderWriter(ext, provider, isHkManaged, isLazy);
        }
        return DESCRIPTORS.containsKey(ext) ? ProviderRenderUtil.renderLine(ext, provider, DESCRIPTORS.get(ext), isHkManaged, isLazy) : ProviderRenderUtil.renderUnknown(provider, isHkManaged, isLazy);
    }

    public static String render(Class<?> ext, Object instance, boolean isHkManaged, boolean isLazy) {
        Class<?> type = instance.getClass();
        String res = null;
        if (ParamInjectionResolver.class.isAssignableFrom(type)) {
            res = ProviderRenderUtil.renderParamInjectionResolver((ParamInjectionResolver)instance, isHkManaged, isLazy);
        } else if (ext.equals(InjectionResolver.class)) {
            res = ProviderRenderUtil.renderInjectionResolver((InjectionResolver)instance, isHkManaged, isLazy);
        }
        return res == null ? ProviderRenderUtil.render(ext, type, isHkManaged, isLazy) : res;
    }

    public static String getTypeName(Class<?> ext) {
        ExtDescriptor desc = DESCRIPTORS.get(ext);
        return desc != null ? desc.name : "Other";
    }

    private static String renderUnknown(Class<?> provider, boolean isHkManaged, boolean isLazy) {
        return String.format(SIMPLE_FORMAT, RenderUtils.renderClassLine(provider, ProviderRenderUtil.collectMarkers(Object.class, provider, isHkManaged, isLazy)));
    }

    private static List<String> collectMarkers(Class<?> ext, Class<?> provider, boolean isHkManaged, boolean isLazy) {
        Annotation filter;
        ArrayList<String> markers = new ArrayList<String>();
        if (isHkManaged) {
            markers.add("jersey managed");
        }
        if (isLazy) {
            markers.add("lazy");
        }
        if (ExceptionMapper.class.equals(ext) && ExtendedExceptionMapper.class.isAssignableFrom(provider)) {
            markers.add("extended");
        }
        if ((filter = FeatureUtils.getAnnotatedAnnotation(provider, NameBinding.class)) != null) {
            markers.add("only @" + filter.annotationType().getSimpleName());
        }
        return markers;
    }

    private static String renderLine(Class ext, Class provider, ExtDescriptor desc, boolean isHkManaged, boolean isLazy) {
        Object[] params = new Object[1 + desc.generics];
        int pos = 0;
        GenericsContext generics = GenericsResolver.resolve((Class)provider, (Class[])new Class[0]).type(ext);
        while (pos < desc.generics) {
            params[pos] = generics.genericAsString(pos++);
        }
        params[pos] = RenderUtils.renderClassLine(provider, ProviderRenderUtil.collectMarkers(ext, provider, isHkManaged, isLazy));
        if ("Object".equals(params[0]) && ProviderRenderUtil.isAbstractCollectionJaxbProvider(provider)) {
            params[0] = "T[], Collection<T>";
        }
        return String.format(desc.format, params);
    }

    private static boolean isAbstractCollectionJaxbProvider(Class provider) {
        return (MessageBodyReader.class.isAssignableFrom(provider) || MessageBodyWriter.class.isAssignableFrom(provider)) && GenericsResolver.resolve((Class)provider, (Class[])new Class[0]).getGenericsInfo().getComposingTypes().stream().map(Class::getName).anyMatch("org.glassfish.jersey.jaxb.internal.AbstractCollectionJaxbProvider"::equals);
    }

    private static String renderMessageReaderWriter(Class<?> ext, Class provider, boolean isHkManaged, boolean isLazy) {
        Produces produce;
        Consumes consume;
        String media = "";
        if (MessageBodyReader.class.equals(ext) && (consume = FeatureUtils.getAnnotation(provider, Consumes.class)) != null) {
            media = Arrays.toString(consume.value());
        }
        if (MessageBodyWriter.class.equals(ext) && (produce = FeatureUtils.getAnnotation(provider, Produces.class)) != null) {
            media = Arrays.toString(produce.value());
        }
        String res = ProviderRenderUtil.renderLine(ext, provider, DESCRIPTORS.get(ext), isHkManaged, isLazy);
        return String.format("%-100s %s", res, media);
    }

    private static String renderParamInjectionResolver(ParamInjectionResolver instance, boolean hkManaged, boolean lazy) {
        try {
            Field field = ParamInjectionResolver.class.getDeclaredField("valueParamProvider");
            field.setAccessible(true);
            ValueParamProvider param = (ValueParamProvider)field.get(instance);
            Class<?> type = instance.getClass();
            return String.format("@%-30s %s using %s %s", instance.getAnnotation().getSimpleName(), RenderUtils.renderClassLine(type), param.getClass().getSimpleName(), RenderUtils.markers(ProviderRenderUtil.collectMarkers(InjectionResolver.class, type, hkManaged, lazy)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to access provider field", e);
        }
    }

    private static String renderInjectionResolver(InjectionResolver instance, boolean hkManaged, boolean lazy) {
        Class<?> type = instance.getClass();
        return String.format(INJECTION_FORMAT, instance.getAnnotation().getSimpleName(), RenderUtils.renderClassLine(type, ProviderRenderUtil.collectMarkers(InjectionResolver.class, type, hkManaged, lazy)));
    }

    private static class ExtDescriptor {
        public String name;
        public String format;
        public int generics;

        ExtDescriptor(String name, String format, int generics) {
            this.name = name;
            this.format = format;
            this.generics = generics;
        }
    }
}

