/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf;

import io.dropwizard.testing.ConfigOverride;
import java.util.Collections;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.client.TestClientFactory;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideExtensionValue;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideValue;

public abstract class ExtensionBuilder<T extends ExtensionBuilder, C extends ExtensionConfig> {
    protected final C cfg;

    public ExtensionBuilder(C cfg) {
        this.cfg = cfg;
    }

    public T configOverrides(String ... values) {
        ((ExtensionConfig)this.cfg).configOverrides = ConfigOverrideUtils.mergeRaw(((ExtensionConfig)this.cfg).configOverrides, values);
        return this.self();
    }

    @SafeVarargs
    public final <K extends ConfigOverride> T configOverrides(K ... values) {
        Collections.addAll(((ExtensionConfig)this.cfg).configOverrideObjects, values);
        return this.self();
    }

    public T configOverride(String key, Supplier<String> supplier) {
        this.configOverrides(new ConfigOverrideValue[]{new ConfigOverrideValue(key, supplier)});
        return this.self();
    }

    public T configOverrideByExtension(ExtensionContext.Namespace namespace, String key) {
        return this.configOverrideByExtension(namespace, key, key);
    }

    public T configOverrideByExtension(ExtensionContext.Namespace namespace, String storageKey, String configPath) {
        this.configOverrides(new ConfigOverrideExtensionValue[]{new ConfigOverrideExtensionValue(namespace, storageKey, configPath)});
        return this.self();
    }

    @SafeVarargs
    public final T hooks(Class<? extends GuiceyConfigurationHook> ... hooks) {
        ((ExtensionConfig)this.cfg).hookClasses(hooks);
        return this.self();
    }

    public T hooks(GuiceyConfigurationHook ... hooks) {
        ((ExtensionConfig)this.cfg).hookInstances(hooks);
        return this.self();
    }

    public T debug() {
        ((ExtensionConfig)this.cfg).tracker.debug = true;
        return this.self();
    }

    public T reuseApplication() {
        ((ExtensionConfig)this.cfg).reuseApp = true;
        return this.self();
    }

    public T clientFactory(TestClientFactory factory) {
        ((ExtensionConfig)this.cfg).clientFactory = factory;
        return this.self();
    }

    private T self() {
        return (T)this;
    }
}

