/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module;

import com.google.common.collect.Sets;
import com.google.inject.Module;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.cli.Command;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.sign.DisableSupport;
import ru.vyarus.dropwizard.guice.module.context.option.OptionsInfo;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsInfo;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class GuiceyConfigurationInfo {
    private final ConfigurationInfo context;
    private final StatsInfo stats;
    private final OptionsInfo options;
    private final ExtensionsHolder holder;
    private final ConfigurationTree configurationTree;

    @Inject
    public GuiceyConfigurationInfo(ConfigurationInfo context, StatsInfo stats, OptionsInfo options, ExtensionsHolder holder, ConfigurationTree configurationTree) {
        this.context = context;
        this.stats = stats;
        this.options = options;
        this.holder = holder;
        this.configurationTree = configurationTree;
    }

    public ConfigurationInfo getData() {
        return this.context;
    }

    public StatsInfo getStats() {
        return this.stats;
    }

    public OptionsInfo getOptions() {
        return this.options;
    }

    public ConfigurationTree getConfigurationTree() {
        return this.configurationTree;
    }

    public List<ItemId<Object>> getItemsByScope(ConfigScope specialScope) {
        return this.getItemsByScope(specialScope.getKey());
    }

    public List<ItemId<Object>> getItemsByScope(ItemId scope) {
        return this.context.getItems(Filters.enabled().and(Filters.registeredBy(scope)));
    }

    public List<ItemId<Object>> getItemsByScope(Class<?> scope) {
        return this.getItemsByScope(ItemId.from(scope));
    }

    public Set<ItemId> getActiveScopes() {
        return this.getActiveScopes(true);
    }

    public Set<ItemId> getActiveScopes(boolean countDisables) {
        HashSet res = Sets.newHashSet();
        this.context.getItems(it -> {
            res.addAll(it.getRegisteredBy());
            if (countDisables && it instanceof DisableSupport) {
                res.addAll(((DisableSupport)((Object)it)).getDisabledBy());
            }
            return true;
        });
        return res;
    }

    public <T extends ItemInfo> T getInfo(Class<?> type) {
        List<T> res = this.getInfos(type);
        return (T)(res.isEmpty() ? null : (ItemInfo)res.get(0));
    }

    public <T extends ItemInfo> List<T> getInfos(Class<?> type) {
        return this.getData().getInfos(type);
    }

    public List<Class<Command>> getCommands() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Command));
    }

    public List<Class<GuiceyBundle>> getGuiceyBundles() {
        return ItemId.typesOnly(this.getGuiceyBundleIds());
    }

    public List<ItemId<GuiceyBundle>> getGuiceyBundleIds() {
        return this.context.getItems(ConfigItem.Bundle, Filters.enabled());
    }

    public List<Class<ConfiguredBundle>> getDropwizardBundles() {
        return ItemId.typesOnly(this.getDropwizardBundleIds());
    }

    public List<ItemId<ConfiguredBundle>> getDropwizardBundleIds() {
        return this.context.getItems(ConfigItem.DropwizardBundle, Filters.enabled());
    }

    public List<Class<GuiceyBundle>> getBundlesFromLookup() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Bundle, Filters.lookupBundles()));
    }

    public List<Class<Object>> getDirectBundles() {
        return ItemId.typesOnly(this.context.getItems(Filters.bundles().and(Filters.enabled()).and(Filters.transitiveBundles().negate())));
    }

    public List<Class<Object>> getBundlesDisabled() {
        return ItemId.typesOnly(this.context.getItems(Filters.bundles().and(Filters.enabled().negate())));
    }

    public List<Class<Object>> getRelativelyInstalledBundles(Class<?> bundle) {
        return ItemId.typesOnly(this.context.getItems(Filters.bundles().and(Filters.enabled()).and(Filters.registrationScope(bundle))));
    }

    public List<Class<Module>> getModules() {
        return ItemId.typesOnly(this.getModuleIds());
    }

    public List<ItemId<Module>> getModuleIds() {
        return this.context.getItems(ConfigItem.Module, Filters.enabled());
    }

    public List<Class<Module>> getNormalModules() {
        return ItemId.typesOnly(this.getNormalModuleIds());
    }

    public List<ItemId<Module>> getNormalModuleIds() {
        return this.context.getItems(ConfigItem.Module, Filters.enabled().and(Filters.overridingModule().negate()));
    }

    public List<Class<Module>> getOverridingModules() {
        return ItemId.typesOnly(this.getOverridingModuleIds());
    }

    public List<ItemId<Module>> getOverridingModuleIds() {
        return this.context.getItems(ConfigItem.Module, Filters.enabled().and(Filters.overridingModule()));
    }

    public List<Class<Module>> getModulesDisabled() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Module, Filters.enabled().negate()));
    }

    public List<Class<FeatureInstaller>> getInstallers() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Installer, Filters.enabled()));
    }

    public List<Class<FeatureInstaller>> getInstallersFromScan() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Installer, Filters.enabled().and(Filters.fromScan())));
    }

    public List<Class<FeatureInstaller>> getInstallersDisabled() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Installer, Filters.enabled().negate()));
    }

    public List<Class<FeatureInstaller>> getInstallersOrdered() {
        return this.holder.getInstallerTypes();
    }

    public List<Class<Object>> getExtensions() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Extension, Filters.enabled()));
    }

    public List<Class<Object>> getExtensions(Class<? extends FeatureInstaller> installer) {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Extension, Filters.installedBy(installer)));
    }

    public List<Class<Object>> getExtensionsFromScan() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Extension, Filters.enabled().and(Filters.fromScan())));
    }

    public List<Class<Object>> getExtensionsFromBindings() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Extension, Filters.enabled().and(Filters.fromBinding())));
    }

    public List<Class<Object>> getExtensionsRegisteredManually() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Extension, Filters.enabled().and(it -> it.getRegistrationScopeType().equals((Object)ConfigScope.Application) || it.getRegistrationScopeType().equals((Object)ConfigScope.GuiceyBundle))));
    }

    public List<Class<Object>> getExtensionsRegisteredManauallyOnly() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Extension, Filters.enabled().and(Filters.fromScan().negate()).and(Filters.fromBinding().negate())));
    }

    public List<Class<Object>> getExtensionsOrdered(Class<? extends FeatureInstaller> installer) {
        List<Class<?>> extensions = this.holder.getExtensions(installer);
        return extensions == null ? Collections.emptyList() : extensions;
    }

    public List<Class<Object>> getExtensionsDisabled() {
        return ItemId.typesOnly(this.context.getItems(ConfigItem.Extension, Filters.enabled().negate()));
    }
}

