/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.stat;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;

public final class StatsInfo {
    private final StatsTracker tracker;

    public StatsInfo(StatsTracker tracker) {
        this.tracker = tracker;
    }

    public long time(Stat name) {
        name.requiresTimer();
        Stopwatch stopwatch = this.tracker.getTimers().get((Object)name);
        return stopwatch == null ? 0L : stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }

    public String humanTime(Stat name) {
        name.requiresTimer();
        Preconditions.checkState((boolean)name.isTimer(), (String)"Stat %s is not timer stat", (Object)((Object)name));
        Stopwatch stopwatch = this.tracker.getTimers().get((Object)name);
        return stopwatch == null ? "0" : stopwatch.toString();
    }

    public int count(Stat name) {
        name.requiresCounter();
        Integer value = this.tracker.getCounters().get((Object)name);
        return value == null ? 0 : value;
    }

    public List<String> getGuiceStats() {
        return this.tracker.getGuiceStats().getMessages();
    }
}

