/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug;

import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceProvisionRenderer;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;

public class GuiceProvisionDiagnostic
implements GuiceyBundle {
    private final Logger logger = LoggerFactory.getLogger(GuiceProvisionDiagnostic.class);
    private final ListMultimap<Binding<?>, Duration> data = LinkedListMultimap.create();
    private final boolean printStartupReport;

    public GuiceProvisionDiagnostic(boolean printStartupReport) {
        this.printStartupReport = printStartupReport;
    }

    @Override
    public void run(GuiceyEnvironment environment) throws Exception {
        environment.modules(new Module[]{new ProvisionListenerModule((Multimap<Binding<?>, Duration>)this.data)});
        if (this.printStartupReport) {
            environment.onApplicationStartup(injector -> this.logger.info("Guice bindings provision time: {}", (Object)this.renderReport()));
        }
    }

    public void clear() {
        this.data.clear();
    }

    public ListMultimap<Binding<?>, Duration> getRecordedData() {
        return LinkedListMultimap.create(this.data);
    }

    public String renderReport() {
        return new GuiceProvisionRenderer().render((ListMultimap<Binding<?>, Duration>)LinkedListMultimap.create(this.data));
    }

    public static class ProvisionListenerModule
    extends AbstractModule {
        private final Multimap<Binding<?>, Duration> provisions;

        public ProvisionListenerModule(Multimap<Binding<?>, Duration> provisions) {
            this.provisions = provisions;
        }

        protected void configure() {
            this.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListener(){

                public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    provision.provision();
                    provisions.put((Object)provision.getBinding(), (Object)stopwatch.stop().elapsed());
                }
            }});
        }
    }
}

