/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug;

import com.google.common.base.Stopwatch;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.component.LifeCycle;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.debug.report.start.DropwizardBundlesTracker;
import ru.vyarus.dropwizard.guice.debug.report.start.ManagedTracker;
import ru.vyarus.dropwizard.guice.debug.report.start.ShutdownTimeInfo;
import ru.vyarus.dropwizard.guice.debug.report.start.ShutdownTimeRenderer;
import ru.vyarus.dropwizard.guice.debug.report.start.StartupTimeInfo;
import ru.vyarus.dropwizard.guice.debug.report.start.StartupTimeRenderer;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.stat.DetailStat;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsInfo;
import ru.vyarus.dropwizard.guice.module.lifecycle.UniqueGuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BeforeInitEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesInitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ApplicationRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BeforeRunEvent;

public class StartupTimeDiagnostic
extends UniqueGuiceyLifecycleListener {
    private final Logger logger = LoggerFactory.getLogger(StartupTimeDiagnostic.class);
    private final StartupTimeInfo start = new StartupTimeInfo();
    private final ShutdownTimeInfo stop = new ShutdownTimeInfo();
    private DropwizardBundlesTracker bundlesTracker;

    @Override
    protected void beforeInit(BeforeInitEvent event) {
        this.bundlesTracker = new DropwizardBundlesTracker(event.getStats(), this.start, event.getBootstrap());
    }

    @Override
    protected void bundlesInitialized(BundlesInitializedEvent event) {
        this.start.setGuiceyBundlesInitOrder(event.getBundles().stream().map(Object::getClass).collect(Collectors.toList()));
    }

    @Override
    protected void beforeRun(BeforeRunEvent event) {
        new ManagedTracker(this.start, this.stop, event.getEnvironment().lifecycle());
        final Stopwatch jerseyTime = Stopwatch.createUnstarted();
        event.getEnvironment().jersey().register((Object)new ApplicationEventListener(){

            public void onEvent(ApplicationEvent applicationEvent) {
                ApplicationEvent.Type type = applicationEvent.getType();
                if (type == ApplicationEvent.Type.INITIALIZATION_START) {
                    jerseyTime.start();
                } else if (type == ApplicationEvent.Type.INITIALIZATION_FINISHED) {
                    StartupTimeDiagnostic.this.start.setJerseyTime(jerseyTime.elapsed());
                }
            }

            public RequestEventListener onRequest(RequestEvent requestEvent) {
                return null;
            }
        });
    }

    @Override
    protected void applicationRun(ApplicationRunEvent event) {
        event.getConfigurationInfo().getGuiceyBundleIds().forEach(id -> {
            List transitive = event.getConfigurationInfo().getData().getItems(itemInfo -> ConfigItem.Bundle.equals((Object)itemInfo.getItemType()) && itemInfo.getRegistrationScope().equals(id)).stream().map(ItemId::getType).collect(Collectors.toList());
            if (!transitive.isEmpty()) {
                this.start.getGuiceyBundleTransitives().putAll(id.getType(), transitive);
            }
        });
        event.registerJettyListener(new JettyListener(event));
    }

    private class JettyListener
    implements LifeCycle.Listener {
        private final Stopwatch startTime;
        private final Stopwatch stopTime;
        private final List<Class<?>> startupEvents;
        private final ApplicationRunEvent event;
        private Duration startListenersTime;
        private final StatsInfo stats;

        JettyListener(ApplicationRunEvent event) {
            this.event = event;
            this.startTime = Stopwatch.createUnstarted();
            this.stopTime = Stopwatch.createUnstarted();
            this.startupEvents = new ArrayList();
            this.stats = ((GuiceyConfigurationInfo)event.getInjector().getInstance(GuiceyConfigurationInfo.class)).getStats();
        }

        public void lifeCycleStarting(LifeCycle event) {
            this.startTime.start();
        }

        public void lifeCycleStarted(LifeCycle evt) {
            StartupTimeDiagnostic.this.start.setWebTime(StartupTimeDiagnostic.this.bundlesTracker.getWebTimer().stop().elapsed());
            StartupTimeDiagnostic.this.start.setLifecycleTime(this.startTime.elapsed());
            StartupTimeDiagnostic.this.start.setStats(this.stats);
            this.startupEvents.addAll(this.stats.getDetailedStats(DetailStat.Listener).keySet());
            this.startListenersTime = this.stats.duration(Stat.ListenersTime);
            StartupTimeDiagnostic.this.start.getWebEvents().addAll(this.startupEvents);
            StartupTimeDiagnostic.this.start.getWebEvents().removeAll(StartupTimeDiagnostic.this.start.getInitEvents());
            StartupTimeDiagnostic.this.start.getWebEvents().removeAll(StartupTimeDiagnostic.this.start.getRunEvents());
            StartupTimeDiagnostic.this.logger.info("Application startup time: {}", (Object)new StartupTimeRenderer().render(StartupTimeDiagnostic.this.start));
        }

        public void lifeCycleStopping(LifeCycle event) {
            this.stopTime.start();
        }

        public void lifeCycleStopped(LifeCycle event) {
            StartupTimeDiagnostic.this.stop.setStopTime(this.stopTime.stop().elapsed());
            StartupTimeDiagnostic.this.stop.getEvents().addAll(this.stats.getDetailedStats(DetailStat.Listener).keySet());
            StartupTimeDiagnostic.this.stop.getEvents().removeAll(this.startupEvents);
            Duration shutdownListeners = this.stats.duration(Stat.ListenersTime);
            StartupTimeDiagnostic.this.stop.setListenersTime(this.startListenersTime != null ? shutdownListeners.minus(this.startListenersTime) : shutdownListeners);
            StartupTimeDiagnostic.this.stop.setStats(this.stats);
            StartupTimeDiagnostic.this.logger.info("Application shutdown time: {}", (Object)new ShutdownTimeRenderer().render(StartupTimeDiagnostic.this.stop));
        }
    }
}

