/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;

public final class ContextTreeConfig {
    private final Set<ConfigItem> items = new HashSet<ConfigItem>();
    private final Set<Class<?>> scopes = new HashSet();
    private boolean disables;
    private boolean notUsedInstallers;
    private boolean duplicateRegistrations;
    private boolean emptyBundles;

    public Set<ConfigItem> getHiddenItems() {
        return this.items;
    }

    public Set<Class<?>> getHiddenScopes() {
        return this.scopes;
    }

    public boolean isHideDisables() {
        return this.disables;
    }

    public boolean isHideNotUsedInstallers() {
        return this.notUsedInstallers;
    }

    public boolean isHideDuplicateRegistrations() {
        return this.duplicateRegistrations;
    }

    public boolean isHideEmptyBundles() {
        return this.emptyBundles;
    }

    public ContextTreeConfig hideModules() {
        this.items.add(ConfigItem.Module);
        return this;
    }

    public ContextTreeConfig hideInstallers() {
        this.items.add(ConfigItem.Installer);
        return this;
    }

    public ContextTreeConfig hideExtensions() {
        this.items.add(ConfigItem.Extension);
        return this;
    }

    public ContextTreeConfig hideCommands() {
        this.items.add(ConfigItem.Command);
        return this;
    }

    public ContextTreeConfig hideScopes(Class<?> ... avoid) {
        Collections.addAll(this.scopes, avoid);
        return this;
    }

    public ContextTreeConfig hideDisables() {
        this.disables = true;
        return this;
    }

    public ContextTreeConfig hideNotUsedInstallers() {
        this.notUsedInstallers = true;
        return this;
    }

    public ContextTreeConfig hideDuplicateRegistrations() {
        this.duplicateRegistrations = true;
        return this;
    }

    public ContextTreeConfig hideEmptyBundles() {
        this.emptyBundles = true;
        return this;
    }
}

