/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.hook;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.stat.DetailStat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;
import ru.vyarus.dropwizard.guice.module.installer.util.PropertyUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public final class ConfigurationHooksSupport {
    public static final String HOOKS_PROPERTY = "guicey.hooks";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationHooksSupport.class);
    private static final ThreadLocal<Set<GuiceyConfigurationHook>> HOOKS = new ThreadLocal();
    private static final ThreadLocal<Map<String, String>> ALIASES = new ThreadLocal();

    private ConfigurationHooksSupport() {
    }

    public static void register(GuiceyConfigurationHook hook) {
        if (HOOKS.get() == null) {
            HOOKS.set(new LinkedHashSet());
        }
        HOOKS.get().add(hook);
    }

    public static void registerSystemHookAlias(String alias, Class<?> hook) {
        Map<String, String> aliases = ALIASES.get();
        if (aliases == null) {
            aliases = new HashMap<String, String>();
            ALIASES.set(aliases);
        }
        String hookName = hook.getName();
        String registeredHookName = aliases.get(alias);
        if (registeredHookName != null && !hookName.equals(registeredHookName)) {
            LOGGER.info("Hook {} alias '{}' registration overridden with hook {}", new Object[]{registeredHookName, alias, hookName});
        }
        aliases.put(alias, hookName);
    }

    public static Map<String, String> getSystemHookAliases() {
        return ALIASES.get() != null ? ALIASES.get() : Collections.emptyMap();
    }

    public static void logRegisteredAliases() {
        if (!ConfigurationHooksSupport.getSystemHookAliases().isEmpty()) {
            StringBuilder res = new StringBuilder().append(Reporter.NEWLINE).append(Reporter.NEWLINE);
            for (Map.Entry<String, String> entry : ConfigurationHooksSupport.getSystemHookAliases().entrySet()) {
                res.append("    ").append(String.format("%-30s", entry.getKey())).append(entry.getValue()).append(Reporter.NEWLINE);
            }
            LOGGER.info("Available hook aliases [ -D{}=alias ]: {}", (Object)HOOKS_PROPERTY, (Object)res.toString());
        }
    }

    public static void loadSystemHooks() {
        List<GuiceyConfigurationHook> hooks = PropertyUtils.getProperty(HOOKS_PROPERTY, ConfigurationHooksSupport.getSystemHookAliases());
        hooks.forEach(ConfigurationHooksSupport::register);
    }

    public static void reset() {
        HOOKS.remove();
        ALIASES.remove();
        System.clearProperty(HOOKS_PROPERTY);
    }

    public static Set<GuiceyConfigurationHook> run(GuiceBundle.Builder builder, StatsTracker stat) {
        Set<GuiceyConfigurationHook> hooks = HOOKS.get();
        if (hooks != null) {
            hooks.forEach(l -> {
                Stopwatch timer = stat.detailTimer(DetailStat.Hook, l.getClass());
                try {
                    l.configure(builder);
                }
                catch (Exception ex) {
                    Throwables.throwIfUnchecked((Throwable)ex);
                    throw new IllegalStateException("Failed to run hook", ex);
                }
                timer.stop();
            });
        }
        ConfigurationHooksSupport.reset();
        return hooks == null ? Collections.emptySet() : hooks;
    }

    public static int count() {
        return HOOKS.get() != null ? HOOKS.get().size() : 0;
    }
}

