/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.info.DropwizardBundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.GuiceyBundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.InstallerItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;

public final class Disables {
    private Disables() {
    }

    public static Predicate<ItemInfo> registeredBy(ConfigScope ... types) {
        return Disables.registeredBy((Class[])Arrays.stream(types).map(ConfigScope::getType).toArray(Class[]::new));
    }

    public static Predicate<ItemInfo> registeredBy(Class<?> ... types) {
        return input -> Arrays.asList(types).contains(input.getRegistrationScope().getType());
    }

    public static Predicate<ItemInfo> registeredBy(ItemId ... scopes) {
        return input -> Arrays.asList(scopes).contains(input.getRegistrationScope());
    }

    public static <T extends ItemInfo> Predicate<T> itemType(ConfigItem ... types) {
        return Filters.type(types);
    }

    public static Predicate<ExtensionItemInfo> extension() {
        return Disables.itemType(ConfigItem.Extension);
    }

    @SafeVarargs
    public static Predicate<ExtensionItemInfo> installedBy(Class<? extends FeatureInstaller> ... installers) {
        List<Class<? extends FeatureInstaller>> deny = Arrays.asList(installers);
        return Disables.extension().and(info -> deny.contains(info.getInstalledBy()));
    }

    public static Predicate<ModuleItemInfo> module() {
        return Disables.itemType(ConfigItem.Module);
    }

    public static Predicate<GuiceyBundleItemInfo> bundle() {
        return Disables.itemType(ConfigItem.Bundle);
    }

    public static Predicate<DropwizardBundleItemInfo> dropwizardBundle() {
        return Disables.itemType(ConfigItem.DropwizardBundle);
    }

    public static Predicate<InstallerItemInfo> installer() {
        return Disables.itemType(ConfigItem.Installer);
    }

    public static Predicate<ItemInfo> type(Class<?> ... types) {
        return input -> Arrays.asList(types).contains(input.getType());
    }

    public static Predicate<ItemInfo> inPackage(String ... pkgs) {
        return input -> {
            String typePkg = input.getType().getPackage().getName();
            return Arrays.stream(pkgs).anyMatch(typePkg::startsWith);
        };
    }

    public static Predicate<ExtensionItemInfo> webExtension() {
        return Disables.extension().and(ExtensionItemInfo::isWebExtension);
    }

    public static Predicate<ExtensionItemInfo> jerseyExtension() {
        return Disables.extension().and(ExtensionItemInfo::isJerseyExtension);
    }
}

