/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.bundle;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.option.Option;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyCommonRegistration;
import ru.vyarus.dropwizard.guice.module.installer.util.BundleSupport;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;

public class GuiceyBootstrap
implements GuiceyCommonRegistration<GuiceyBootstrap> {
    private final ConfigurationContext context;
    private final List<Class<? extends GuiceyBundle>> bundlesPath;
    private final List<GuiceyBundle> initOrder;

    public GuiceyBootstrap(ConfigurationContext context, List<Class<? extends GuiceyBundle>> bundlesPath, List<GuiceyBundle> initOrder) {
        this.context = context;
        this.bundlesPath = bundlesPath;
        this.initOrder = initOrder;
    }

    @SafeVarargs
    public final GuiceyBootstrap installers(Class<? extends FeatureInstaller> ... installers) {
        this.context.registerInstallers(installers);
        return this;
    }

    public GuiceyBootstrap bundles(GuiceyBundle ... bundles) {
        BundleSupport.initBundles(this.context, this, this.bundlesPath, this.initOrder, this.context.registerBundles(bundles));
        return this;
    }

    public GuiceyBootstrap dropwizardBundles(ConfiguredBundle ... bundles) {
        this.context.registerDropwizardBundles(bundles);
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap disableInstallers(Class<? extends FeatureInstaller> ... installers) {
        this.context.disableInstallers(installers);
        return this;
    }

    @Override
    public <K extends Configuration> Bootstrap<K> bootstrap() {
        return this.context.getBootstrap();
    }

    @Override
    public <K extends Configuration> Application<K> application() {
        return this.context.getBootstrap().getApplication();
    }

    @Override
    public <V, K extends Enum<? extends Option>> V option(K option) {
        return this.context.option(option);
    }

    @Override
    public GuiceyBootstrap modules(Module ... modules) {
        Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
        this.context.registerModules(modules);
        return this;
    }

    @Override
    public GuiceyBootstrap modulesOverride(Module ... modules) {
        this.context.registerModulesOverride(modules);
        return this;
    }

    @Override
    public GuiceyBootstrap extensions(Class<?> ... extensionClasses) {
        this.context.registerExtensions(extensionClasses);
        return this;
    }

    @Override
    public GuiceyBootstrap extensionsOptional(Class<?> ... extensionClasses) {
        this.context.registerExtensionsOptional(extensionClasses);
        return this;
    }

    @Override
    public GuiceyBootstrap disableExtensions(Class<?> ... extensions) {
        this.context.disableExtensions(extensions);
        return this;
    }

    @Override
    @SafeVarargs
    public final GuiceyBootstrap disableModules(Class<? extends Module> ... modules) {
        this.context.disableModules(modules);
        return this;
    }

    @Override
    public GuiceyBootstrap listen(GuiceyLifecycleListener ... listeners) {
        this.context.lifecycle().register(listeners);
        return this;
    }

    @Override
    public <K> GuiceyBootstrap shareState(Class<K> key, K value) {
        this.context.getSharedState().put(key, value);
        return this;
    }

    @Override
    public <K> K sharedState(Class<K> key, Supplier<K> defaultValue) {
        return this.context.getSharedState().get(key, defaultValue);
    }

    @Override
    public <K> Optional<K> sharedState(Class<K> key) {
        return Optional.ofNullable(this.context.getSharedState().get(key));
    }

    @Override
    public <K> K sharedStateOrFail(Class<K> key, String message, Object ... args) {
        return this.context.getSharedState().getOrFail(key, message, args);
    }

    @Override
    public <V> void whenSharedStateReady(Class<V> key, Consumer<V> action) {
        this.context.getSharedState().whenReady(key, action);
    }
}

