/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.Command;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import ru.vyarus.dropwizard.guice.test.TestCommand;
import ru.vyarus.dropwizard.guice.test.TestSupport;
import ru.vyarus.dropwizard.guice.test.util.ConfigModifier;
import ru.vyarus.dropwizard.guice.test.util.RunResult;

public class GuiceyTestSupport<C extends Configuration>
extends DropwizardTestSupport<C> {
    public GuiceyTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, (String)null, configOverrides);
    }

    public GuiceyTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable ConfigurationSourceProvider configSourceProvider, ConfigOverride ... configOverrides) {
        this((Class<Application<C>>)applicationClass, configPath, configSourceProvider, (String)null, configOverrides);
    }

    public GuiceyTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable ConfigurationSourceProvider configSourceProvider, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        super(applicationClass, configPath, configSourceProvider, customPropertyPrefix, new CmdProvider(), configOverrides);
    }

    public GuiceyTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        super(applicationClass, configPath, customPropertyPrefix, new CmdProvider(), configOverrides);
    }

    public GuiceyTestSupport(Class<? extends Application<C>> applicationClass, C configuration) {
        super(applicationClass, configuration, new CmdProvider());
    }

    public GuiceyTestSupport<C> disableManagedLifecycle() {
        ((CmdProvider)this.commandInstantiator).disableManagedSimulation();
        return this;
    }

    @SafeVarargs
    public final GuiceyTestSupport<C> configModifiers(ConfigModifier<C> ... modifiers) {
        return this.configModifiers(Arrays.asList(modifiers));
    }

    public GuiceyTestSupport<C> configModifiers(List<ConfigModifier<C>> modifiers) {
        ((CmdProvider)this.commandInstantiator).configModifiers(modifiers);
        return this;
    }

    public <T> T run(@Nullable TestSupport.RunCallback<T> callback) throws Exception {
        return TestSupport.run(this, callback);
    }

    public RunResult<C> run() throws Exception {
        return TestSupport.run(this);
    }

    public <T> T getBean(Class<T> type) {
        return TestSupport.getBean(this, type);
    }

    public <T> T getBean(Key<T> key) {
        return TestSupport.getBean(this, key);
    }

    public void after() {
        super.after();
        TestCommand cmd = ((CmdProvider)this.commandInstantiator).command;
        if (cmd != null) {
            cmd.stop();
        }
    }

    static class CmdProvider<C extends Configuration>
    implements Function<Application<C>, Command> {
        public TestCommand<C> command;
        private boolean simulateManaged = true;
        private final List<ConfigModifier<C>> modifiers = new ArrayList<ConfigModifier<C>>();

        CmdProvider() {
        }

        public void disableManagedSimulation() {
            Preconditions.checkState((this.command == null ? 1 : 0) != 0, (Object)"Command already initialized");
            this.simulateManaged = false;
        }

        public void configModifiers(List<ConfigModifier<C>> modifiers) {
            Preconditions.checkState((this.command == null ? 1 : 0) != 0, (Object)"Command already initialized");
            this.modifiers.addAll(modifiers);
        }

        @Override
        public Command apply(Application<C> application) {
            Preconditions.checkState((this.command == null ? 1 : 0) != 0, (Object)"Command already created");
            this.command = new TestCommand<C>(application, this.simulateManaged, this.modifiers);
            return this.command;
        }
    }
}

