/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.EnvironmentCommand;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import java.util.List;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.test.util.ConfigModifier;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;

public class TestCommand<C extends Configuration>
extends EnvironmentCommand<C> {
    private final Logger logger = LoggerFactory.getLogger(TestCommand.class);
    private final Class<C> configurationClass;
    private final boolean simulateManaged;
    private final List<ConfigModifier<C>> modifiers;
    private ContainerLifeCycle container;

    public TestCommand(Application<C> application) {
        this(application, true);
    }

    public TestCommand(Application<C> application, boolean simulateManaged) {
        this(application, simulateManaged, null);
    }

    public TestCommand(Application<C> application, boolean simulateManaged, List<ConfigModifier<C>> modifiers) {
        super(application, "guicey-test", "Specific command to run guice context without jetty server");
        this.cleanupAsynchronously();
        this.configurationClass = application.getConfigurationClass();
        this.simulateManaged = simulateManaged;
        this.modifiers = modifiers;
    }

    protected void run(Bootstrap<C> bootstrap, Namespace namespace, C configuration) throws Exception {
        if (this.modifiers != null) {
            ConfigOverrideUtils.runModifiers(configuration, this.modifiers);
        }
        super.run(bootstrap, namespace, configuration);
    }

    protected void run(Environment environment, Namespace namespace, C configuration) throws Exception {
        this.container = this.simulateManaged ? new ContainerLifeCycle() : new NoManagedContainerLifeCycle();
        environment.lifecycle().attach(this.container);
        this.container.start();
        if (!this.simulateManaged) {
            this.logger.info("NOTE: Managed lifecycle support disabled!");
        }
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to stop managed objects container", e);
            }
            this.container.destroy();
        }
        this.cleanup();
    }

    protected Class<C> getConfigurationClass() {
        return this.configurationClass;
    }

    public static class NoManagedContainerLifeCycle
    extends ContainerLifeCycle {
        public boolean addBean(Object o) {
            return false;
        }
    }
}

