/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.builder;

import com.google.common.base.Preconditions;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.ConfigOverride;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.util.ConfigModifier;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;

public abstract class BaseBuilder<C extends Configuration, T extends BaseBuilder<C, T>> {
    protected final Class<? extends Application<C>> app;
    protected String configPath;
    protected ConfigurationSourceProvider configSourceProvider;
    protected final Map<String, Supplier<String>> configOverrides = new HashMap<String, Supplier<String>>();
    protected final List<ConfigModifier<C>> modifiers = new ArrayList<ConfigModifier<C>>();
    protected C configObject;
    protected String propertyPrefix;
    protected String restMapping;

    public BaseBuilder(Class<? extends Application<C>> app) {
        this.app = app;
    }

    public T config(@Nullable String path) {
        this.configPath = path;
        return this.self();
    }

    public T config(@Nullable C config) {
        this.configObject = config;
        return this.self();
    }

    public T configSourceProvider(@Nullable ConfigurationSourceProvider provider) {
        this.configSourceProvider = provider;
        return this.self();
    }

    public T configOverrides(String ... overrides) {
        for (String over : overrides) {
            this.configOverride(over);
        }
        return this.self();
    }

    public T configOverride(@Nullable String override) {
        if (override != null) {
            int idx = override.indexOf(58);
            Preconditions.checkState((idx > 0 ? 1 : 0) != 0, (String)"Incorrect configuration override declaration: must be 'key: value', but found '%s'", (Object)override);
            this.configOverride(override.substring(0, idx).trim(), override.substring(idx + 1).trim());
        }
        return this.self();
    }

    public T configOverride(String key, String value) {
        return this.configOverride(key, () -> value);
    }

    public T configOverride(String key, Supplier<String> value) {
        this.configOverrides.put(key, value);
        return this.self();
    }

    @SafeVarargs
    public final T configModifiers(ConfigModifier<C> ... modifiers) {
        Collections.addAll(this.modifiers, modifiers);
        return this.self();
    }

    @SafeVarargs
    public final T configModifiers(Class<? extends ConfigModifier<? extends Configuration>> ... modifiers) {
        this.modifiers.addAll(ConfigOverrideUtils.createModifiers(modifiers));
        return this.self();
    }

    public T propertyPrefix(@Nullable String prefix) {
        this.propertyPrefix = prefix;
        return this.self();
    }

    @SafeVarargs
    public final T hooks(Class<? extends GuiceyConfigurationHook> ... hooks) {
        HooksUtil.register(HooksUtil.create(hooks));
        return this.self();
    }

    public T hooks(GuiceyConfigurationHook ... hooks) {
        HooksUtil.register(Arrays.asList(hooks));
        return this.self();
    }

    protected ConfigOverride[] prepareOverrides(String prefix) {
        ConfigOverride[] override = new ConfigOverride[this.configOverrides.size() + (this.restMapping == null ? 0 : 1)];
        int i = 0;
        for (Map.Entry<String, Supplier<String>> entry : this.configOverrides.entrySet()) {
            override[i++] = ConfigOverride.config((String)prefix, (String)entry.getKey(), entry.getValue());
        }
        if (this.restMapping != null) {
            override[i] = ConfigOverrideUtils.overrideRestMapping(prefix, this.restMapping);
        }
        return override;
    }

    public T restMapping(String restMapping) {
        this.restMapping = restMapping;
        return this.self();
    }

    private T self() {
        return (T)this;
    }
}

