/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.env.field;

import com.google.inject.Binding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.TestFieldUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.TestExecutionListener;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public abstract class AnnotatedTestFieldSetup<A extends Annotation, T>
implements TestEnvironmentSetup,
TestExecutionListener {
    protected static final String FIELD_MANUAL = "manual_creation";
    protected static final String FIELD_INJECTED = "value_injected";
    protected boolean appPerClass;
    protected Class<?> regTestClass;
    protected String setupContextName;
    protected List<AnnotatedField<A, T>> fields;
    protected ExtensionContext setupContext;
    private final Class<A> fieldAnnotation;
    private final Class<T> fieldType;
    private final String storageKey;
    private TestInstances regTestInstance;

    public AnnotatedTestFieldSetup(Class<A> fieldAnnotation, Class<T> fieldType, String storageKey) {
        this.fieldAnnotation = fieldAnnotation;
        this.fieldType = fieldType;
        this.storageKey = storageKey;
    }

    @Override
    public Object setup(TestExtension extension) {
        this.appPerClass = extension.isApplicationStartedForClass();
        this.setupContext = extension.getJunitContext();
        this.regTestClass = this.setupContext.getRequiredTestClass();
        this.regTestInstance = this.setupContext.getTestInstances().orElse(null);
        this.setupContextName = TestSetupUtils.getContextTestName(this.setupContext);
        this.fields = this.lookupFields(this.setupContext, () -> extension.findAnnotatedFields(this.fieldAnnotation, this.fieldType));
        if (!this.fields.isEmpty()) {
            this.registerHooks(extension);
            extension.listen(this);
        }
        return null;
    }

    protected abstract void fieldDetected(ExtensionContext var1, AnnotatedField<A, T> var2);

    protected abstract void registerHooks(TestExtension var1);

    protected abstract <K> void initializeField(AnnotatedField<A, T> var1, T var2);

    protected abstract void beforeValueInjection(EventContext var1, AnnotatedField<A, T> var2);

    protected abstract T injectFieldValue(EventContext var1, AnnotatedField<A, T> var2);

    protected abstract void report(EventContext var1, List<AnnotatedField<A, T>> var2);

    protected abstract void beforeTest(EventContext var1, AnnotatedField<A, T> var2, T var3);

    protected abstract void afterTest(EventContext var1, AnnotatedField<A, T> var2, T var3);

    @Override
    public void starting(EventContext context) throws Exception {
        for (AnnotatedField<A, T> field : this.fields) {
            T existing;
            if ((this.regTestInstance != null || field.isStatic()) && (existing = field.getValue(this.regTestInstance)) != null) {
                this.initializeField(field, existing);
                field.setCustomData(FIELD_MANUAL, true);
                field.setCustomData(FIELD_INJECTED, field.isStatic() ? field.getDeclaringClass() : field.findRequiredInstance(this.regTestInstance));
                continue;
            }
            this.initializeField(field, null);
        }
    }

    @Override
    public void started(EventContext context) {
        if (context.isDebug() && !this.fields.isEmpty()) {
            this.report(new EventContext(this.setupContext, true), this.fields);
        }
    }

    @Override
    public void beforeAll(EventContext context) {
        Class testClass = context.getJunitContext().getRequiredTestClass();
        if (testClass == this.regTestClass) {
            this.injectValues(context, this.fields, null);
        } else {
            this.validateUnreachableFieldsInNestedTest(testClass);
        }
    }

    @Override
    public void beforeEach(EventContext context) {
        TestInstances testInstances = context.getJunitContext().getRequiredTestInstances();
        this.injectValues(context, this.fields, testInstances);
        this.valueLifecycle(context, this.fields, testInstances, true);
    }

    @Override
    public void afterEach(EventContext context) {
        this.valueLifecycle(context, this.fields, context.getJunitContext().getRequiredTestInstances(), false);
    }

    @Override
    public void stopped(EventContext context) {
        this.fields.forEach(field -> {
            if (field.isStatic() && !field.isCustomDataSet(FIELD_MANUAL)) {
                field.setValue(null, null);
                field.clearCustomData();
            }
        });
    }

    protected List<AnnotatedField<A, T>> lookupFields(ExtensionContext context, Provider<List<AnnotatedField<A, T>>> fieldsProvider) {
        ExtensionContext ctx = this.getClassContext(context);
        List res = this.getOwnFields(ctx);
        if (res == null) {
            res = (List)fieldsProvider.get();
            if (!res.isEmpty()) {
                res.forEach(field -> this.fieldDetected(context, (AnnotatedField<A, T>)field));
            }
            this.getStore(ctx).put((Object)this.storageKey, (Object)res);
        }
        List<AnnotatedField<A, AnnotatedField>> inherited = this.getParentFields(ctx);
        inherited.forEach(AnnotatedField::clearCustomData);
        res.addAll(inherited);
        return res;
    }

    protected void injectValues(EventContext context, List<AnnotatedField<A, T>> fields, TestInstances testInstances) {
        boolean checkFieldValueInvisibleOnInitialization = testInstances != null && this.appPerClass;
        fields.forEach(field -> {
            boolean isAlreadyInjected;
            if (checkFieldValueInvisibleOnInitialization && !field.isStatic()) {
                this.failIfInstanceFieldInitialized((AnnotatedField<A, T>)field, testInstances);
            }
            this.beforeValueInjection(context, (AnnotatedField<A, T>)field);
            Object instance = field.findRequiredInstance(testInstances);
            boolean bl = isAlreadyInjected = field.isStatic() && field.isCustomDataSet(FIELD_INJECTED) || !field.isStatic() && instance == field.getCustomData(FIELD_INJECTED);
            if ((instance != null || field.isStatic()) && !isAlreadyInjected) {
                field.setValue(instance, this.injectFieldValue(context, (AnnotatedField<A, T>)field));
                field.setCustomData(FIELD_INJECTED, field.isStatic() ? Boolean.valueOf(true) : instance);
            }
        });
    }

    protected void valueLifecycle(EventContext context, List<AnnotatedField<A, T>> fields, TestInstances testInstances, boolean before) {
        fields.forEach(field -> {
            Object value = field.checkValueNotChanged(testInstances);
            if (before) {
                this.beforeTest(context, (AnnotatedField<A, T>)field, value);
            } else {
                this.afterTest(context, (AnnotatedField<A, T>)field, value);
            }
        });
    }

    protected String getDeclarationErrorPrefix(AnnotatedField<A, T> field) {
        return "Incorrect @" + this.fieldAnnotation.getSimpleName() + " '" + field.toStringField() + "' declaration: ";
    }

    protected void failIfInstanceFieldInitialized(AnnotatedField<A, T> field, TestInstances testInstances) {
        T value = field.getValue(testInstances);
        if (value != null && !field.isCustomDataSet(FIELD_INJECTED)) {
            throw new IllegalStateException(this.getDeclarationErrorPrefix(field) + "field value can't be used because guice context starts in beforeAll phase. Either make field static or remove value (guice will create instance with guice injector)");
        }
    }

    protected void validateUnreachableFieldsInNestedTest(Class<?> testClass) {
        List<AnnotatedField<A, T>> wrongFields = TestFieldUtils.findAnnotatedFields(testClass, this.fieldAnnotation, this.fieldType);
        if (!wrongFields.isEmpty()) {
            throw new IllegalStateException(this.getDeclarationErrorPrefix(wrongFields.get(0)) + "nested test runs under already started application and so new fields could not be added. Either remove annotated fields in nested tests or run application for each test method (with non-static @RegisterExtension field)");
        }
    }

    protected List<AnnotatedField<A, T>> getParentFields(ExtensionContext context) {
        ArrayList<AnnotatedField<A, T>> res = new ArrayList<AnnotatedField<A, T>>();
        ExtensionContext ctx = context.getParent().orElse(null);
        while (ctx != null && ctx.getTestClass().isPresent()) {
            List<AnnotatedField<A, T>> tmp = this.getOwnFields(ctx);
            if (tmp != null) {
                res.addAll(tmp);
            }
            ctx = ctx.getParent().orElse(null);
        }
        return res;
    }

    protected List<AnnotatedField<A, T>> getOwnFields(ExtensionContext context) {
        return (List)this.getStore(context).get((Object)this.storageKey);
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestClass()}));
    }

    protected ExtensionContext getClassContext(ExtensionContext context) {
        ExtensionContext ctx = context;
        while (ctx.getTestMethod().isPresent()) {
            ctx = (ExtensionContext)ctx.getParent().get();
        }
        return ctx;
    }

    protected boolean isInstanceBinding(Binding<?> binding) {
        return binding instanceof InstanceBinding || binding instanceof ProviderInstanceBinding;
    }
}

