/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf;

import com.google.common.base.Preconditions;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.ConfigOverride;
import java.util.Collections;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.jupiter.api.function.ThrowingSupplier;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.client.TestClientFactory;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.util.ConfigModifier;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideExtensionValue;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideValue;

public abstract class ExtensionBuilder<K extends Configuration, T extends ExtensionBuilder<K, T, C>, C extends ExtensionConfig> {
    protected final C cfg;

    public ExtensionBuilder(C cfg) {
        this.cfg = cfg;
    }

    public T with(ThrowingConsumer<T> action) {
        try {
            action.accept(this.self());
        }
        catch (Throwable e) {
            throw new IllegalStateException("Test configuration failed", e);
        }
        return this.self();
    }

    public T config(ThrowingSupplier<K> configProvider) {
        Preconditions.checkState((((ExtensionConfig)this.cfg).confInstance == null ? 1 : 0) != 0, (Object)"Manual configuration instance already set");
        ((ExtensionConfig)this.cfg).confInstance = configProvider;
        return this.self();
    }

    public T configOverrides(String ... values) {
        ((ExtensionConfig)this.cfg).configOverrides = ConfigOverrideUtils.mergeRaw(((ExtensionConfig)this.cfg).configOverrides, values);
        return this.self();
    }

    @SafeVarargs
    public final <K extends ConfigOverride> T configOverrides(K ... values) {
        Collections.addAll(((ExtensionConfig)this.cfg).configOverrideObjects, values);
        return this.self();
    }

    public T configOverride(String key, String value) {
        this.configOverrides(key + ":" + value);
        return this.self();
    }

    public T configOverride(String key, Supplier<String> supplier) {
        this.configOverrides(new ConfigOverrideValue[]{new ConfigOverrideValue(key, supplier)});
        return this.self();
    }

    public T configOverrideByExtension(ExtensionContext.Namespace namespace, String key) {
        return this.configOverrideByExtension(namespace, key, key);
    }

    public T configOverrideByExtension(ExtensionContext.Namespace namespace, String storageKey, String configPath) {
        this.configOverrides(new ConfigOverrideExtensionValue[]{new ConfigOverrideExtensionValue(namespace, storageKey, configPath)});
        return this.self();
    }

    @SafeVarargs
    public final T hooks(Class<? extends GuiceyConfigurationHook> ... hooks) {
        ((ExtensionConfig)this.cfg).hookClasses(hooks);
        return this.self();
    }

    public T hooks(GuiceyConfigurationHook ... hooks) {
        ((ExtensionConfig)this.cfg).hookInstances(hooks);
        return this.self();
    }

    @SafeVarargs
    public final <P extends K> T configModifiers(ConfigModifier<P> ... modifiers) {
        ((ExtensionConfig)this.cfg).configModifierInstances(modifiers);
        return this.self();
    }

    @SafeVarargs
    public final T configModifiers(Class<? extends ConfigModifier<? extends Configuration>> ... modifiers) {
        ((ExtensionConfig)this.cfg).configModifierClasses(modifiers);
        return this.self();
    }

    public T injectOnce() {
        ((ExtensionConfig)this.cfg).injectOnce = true;
        return this.self();
    }

    public T debug() {
        ((ExtensionConfig)this.cfg).tracker.debug = true;
        return this.self();
    }

    public T reuseApplication() {
        ((ExtensionConfig)this.cfg).reuseApp = true;
        return this.self();
    }

    public T disableDefaultExtensions() {
        ((ExtensionConfig)this.cfg).defaultExtensionsEnabled = false;
        return this.self();
    }

    public T clientFactory(TestClientFactory factory) {
        ((ExtensionConfig)this.cfg).clientFactory = factory;
        return this.self();
    }

    private T self() {
        return (T)this;
    }
}

