/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track;

import java.time.Duration;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.GuiceyTestTime;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;

class PerformanceTrack {
    final GuiceyTestTime name;
    final GuiceyTestTime phase;
    Duration loggedDuration;
    Duration duration;

    PerformanceTrack(GuiceyTestTime name, GuiceyTestTime phase) {
        this.name = name;
        this.phase = phase;
    }

    void registerDuration(Duration duration) {
        this.duration = this.duration == null ? duration : this.duration.plus(duration);
    }

    boolean isDurationChanged() {
        return this.loggedDuration == null || this.loggedDuration.compareTo(this.duration) < 0;
    }

    void markLogged() {
        this.loggedDuration = this.duration;
    }

    boolean isRoot() {
        return this.phase == this.name;
    }

    Duration getOverall() {
        return this.duration;
    }

    Duration getIncrease() {
        return this.loggedDuration == null ? this.duration : this.duration.minus(this.loggedDuration);
    }

    public String toString() {
        Object title = this.name.getDisplayName();
        if (this.isRoot()) {
            title = "[" + (String)title + "]";
        }
        return String.format("%-35s: %s", title, PrintUtils.renderTime(this.getOverall(), this.loggedDuration == null ? null : this.getIncrease()));
    }
}

