/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.StackUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.TestDropwizardAppExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.TestGuiceyAppExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionBuilder;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.TestExtensionsTracker;

public final class RegistrationTrackUtils {
    private static final List<Class<?>> EXT_INFRA = ImmutableList.of(ExtensionBuilder.class, TestExtensionsTracker.class, ExtensionConfig.class, RegistrationTrackUtils.class, TestGuiceyAppExtension.class, TestDropwizardAppExtension.class);

    private RegistrationTrackUtils() {
    }

    public static void fromClass(List<String> info, String prefix, Class<?>[] classes, boolean fromAnnotation) {
        String src = fromAnnotation ? prefix : RegistrationTrackUtils.buildSourceLocation(prefix);
        RegistrationTrackUtils.track(info, Arrays.asList(classes), it -> it, it -> src);
    }

    public static void fromInstance(List<String> info, String prefix, Object[] instances) {
        String src = RegistrationTrackUtils.buildSourceLocation(prefix);
        RegistrationTrackUtils.track(info, Arrays.asList(instances), Object::getClass, obj -> src);
    }

    public static void fromField(List<String> info, String prefix, List<AnnotatedField<?, ?>> fields, Object instance) {
        RegistrationTrackUtils.track(info, fields, field -> field.getValue(instance).getClass(), field -> RegistrationTrackUtils.formatSourceLocation(prefix + " " + RegistrationTrackUtils.getFieldDescriptor(field), "at " + RenderUtils.renderClass(field.getDeclaringClass()) + "#" + field.getName()));
    }

    public static String getFieldDescriptor(AnnotatedField<?, ?> field) {
        return RenderUtils.getClassName(field.getDeclaringClass()) + "#" + field.getName();
    }

    private static String buildSourceLocation(String prefix) {
        String source = StackUtils.getCallerSource(EXT_INFRA);
        return RegistrationTrackUtils.formatSourceLocation(prefix, source);
    }

    private static String formatSourceLocation(String prefix, String src) {
        return String.format("%-50s %s", prefix, src);
    }

    private static <T> void track(List<String> info, List<T> objects, Function<T, Class> converter, Function<T, String> marker) {
        for (T obj : objects) {
            Class cls = converter.apply(obj);
            String className = cls.isAnonymousClass() || cls.isSynthetic() ? "<lambda>" : RenderUtils.getClassName(cls);
            info.add(String.format("%-30s \t%s", className, marker.apply(obj)));
        }
    }
}

