/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.EnableHook;
import ru.vyarus.dropwizard.guice.test.jupiter.env.EnableSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.GuiceyTestTime;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.PerformanceTrack;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.RegistrationTrackUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.TrackerReportBuilder;
import ru.vyarus.dropwizard.guice.test.util.ConfigModifier;

public class TestExtensionsTracker {
    public static final String GUICEY_EXTENSIONS_DEBUG = "guicey.extensions.debug";
    public static final String DEBUG_ENABLED = "true";
    public boolean debug;
    protected final List<String> extensionsSource = new ArrayList<String>();
    protected final List<String> hooksSource = new ArrayList<String>();
    protected final List<String> configModifierSource = new ArrayList<String>();
    private final List<PerformanceTrack> performance = new ArrayList<PerformanceTrack>();
    private GuiceyTestTime testPhase;
    private Class<? extends TestEnvironmentSetup> contextSetupObject;
    private final Map<Class<?>, String> fieldSetupObjectsReference = new HashMap();

    public void setContextSetupObject(Class<? extends TestEnvironmentSetup> setup) {
        this.contextSetupObject = setup;
    }

    public final void extensionsFromFields(List<AnnotatedField<EnableSetup, TestEnvironmentSetup>> fields, Object instance) {
        String prefix = "@" + EnableSetup.class.getSimpleName();
        RegistrationTrackUtils.fromField(this.extensionsSource, prefix, fields, instance);
        fields.forEach(field -> this.fieldSetupObjectsReference.put(field.getCachedValue().getClass(), prefix + " " + RegistrationTrackUtils.getFieldDescriptor(field)));
    }

    @SafeVarargs
    public final void extensionsFromAnnotation(Class<? extends Annotation> ann, Class<? extends TestEnvironmentSetup> ... exts) {
        ArrayList<String> tmp = new ArrayList<String>(this.extensionsSource);
        this.extensionsSource.clear();
        RegistrationTrackUtils.fromClass(this.extensionsSource, "@" + ann.getSimpleName() + "(setup)", exts, true);
        this.extensionsSource.addAll(tmp);
    }

    public final void hooksFromFields(List<AnnotatedField<EnableHook, GuiceyConfigurationHook>> fields, boolean baseHooks, Object instance) {
        if (!fields.isEmpty()) {
            ArrayList<String> tmp;
            ArrayList<String> arrayList = tmp = baseHooks ? new ArrayList<String>(this.hooksSource) : Collections.emptyList();
            if (baseHooks) {
                this.hooksSource.clear();
            }
            RegistrationTrackUtils.fromField(this.hooksSource, "@" + EnableHook.class.getSimpleName(), fields, instance);
            this.hooksSource.addAll(tmp);
        }
    }

    @SafeVarargs
    public final void hooksFromAnnotation(Class<? extends Annotation> ann, Class<? extends GuiceyConfigurationHook> ... exts) {
        RegistrationTrackUtils.fromClass(this.hooksSource, "@" + ann.getSimpleName() + "(hooks)", exts, true);
    }

    public final void extensionInstances(TestEnvironmentSetup ... exts) {
        RegistrationTrackUtils.fromInstance(this.extensionsSource, String.format("@%s.setup(obj)", RegisterExtension.class.getSimpleName()), exts);
    }

    @SafeVarargs
    public final void extensionClasses(Class<? extends TestEnvironmentSetup> ... exts) {
        RegistrationTrackUtils.fromClass(this.extensionsSource, String.format("@%s.setup(class)", RegisterExtension.class.getSimpleName()), exts, false);
    }

    @SafeVarargs
    public final List<TestEnvironmentSetup> lookupExtensions(TestEnvironmentSetup ... exts) {
        RegistrationTrackUtils.fromInstance(this.extensionsSource, "lookup (service loader)", exts);
        return Arrays.asList(exts);
    }

    @SafeVarargs
    public final List<TestEnvironmentSetup> defaultExtensions(TestEnvironmentSetup ... exts) {
        RegistrationTrackUtils.fromInstance(this.extensionsSource, "default extension", exts);
        return Arrays.asList(exts);
    }

    public final void hookInstances(GuiceyConfigurationHook ... exts) {
        RegistrationTrackUtils.fromInstance(this.hooksSource, String.format("%s.hooks(obj)", this.getHookContext()), exts);
    }

    @SafeVarargs
    public final void hookClasses(Class<? extends GuiceyConfigurationHook> ... exts) {
        RegistrationTrackUtils.fromClass(this.hooksSource, String.format("%s.hooks(class)", this.getHookContext()), exts, false);
    }

    @SafeVarargs
    public final void configModifiersFromAnnotation(Class<? extends Annotation> ann, Class<? extends ConfigModifier> ... exts) {
        RegistrationTrackUtils.fromClass(this.configModifierSource, "@" + ann.getSimpleName() + "(configModifiers)", exts, true);
    }

    @SafeVarargs
    public final void configModifierClasses(Class<? extends ConfigModifier> ... mods) {
        RegistrationTrackUtils.fromClass(this.configModifierSource, String.format("%s.configModifiers(class)", this.getHookContext()), mods, false);
    }

    public final void configModifierInstances(ConfigModifier ... exts) {
        RegistrationTrackUtils.fromInstance(this.configModifierSource, String.format("%s.configModifiers(obj)", this.getHookContext()), exts);
    }

    public void lifecyclePhase(ExtensionContext context, GuiceyTestTime phase) {
        this.testPhase = phase;
    }

    public void performanceTrack(GuiceyTestTime name, Duration duration) {
        PerformanceTrack track = this.performance.stream().filter(tr -> tr.phase == this.testPhase && tr.name == name).findFirst().orElse(null);
        if (track == null) {
            track = new PerformanceTrack(name, this.testPhase);
            this.performance.add(track);
        }
        track.registerDuration(duration);
    }

    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"})
    public void enableDebugFromSystemProperty() {
        if (!this.debug && DEBUG_ENABLED.equalsIgnoreCase(System.getProperty(GUICEY_EXTENSIONS_DEBUG))) {
            this.debug = true;
        }
    }

    public void logUsedHooksAndSetupObjects(String configPrefix) {
        if (!(!this.debug || this.extensionsSource.isEmpty() && this.hooksSource.isEmpty())) {
            System.out.println(TrackerReportBuilder.buildSetupReport(configPrefix, this.extensionsSource, this.hooksSource));
        }
    }

    public void logOverriddenConfigs(String configPrefix) {
        if (this.debug) {
            System.out.println(TrackerReportBuilder.buildConfigsReport(configPrefix, this.configModifierSource));
        }
    }

    public void logGuiceyTestTime(GuiceyTestTime phase, ExtensionContext context) {
        if (this.debug) {
            System.out.println(TrackerReportBuilder.buildPerformanceReport(this.performance, context, phase));
        }
    }

    private String getHookContext() {
        Object res;
        if (this.contextSetupObject != null) {
            res = this.fieldSetupObjectsReference.get(this.contextSetupObject);
            if (res == null) {
                res = RenderUtils.getClassName(this.contextSetupObject);
            }
        } else {
            res = "@" + RegisterExtension.class.getSimpleName();
        }
        return res;
    }
}

