/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.GuiceyTestTime;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.PerformanceTrack;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public final class TrackerReportBuilder {
    private TrackerReportBuilder() {
    }

    public static String buildSetupReport(String configPrefix, List<String> setups, List<String> hooks) {
        StringBuilder res = new StringBuilder(500).append("\nGuicey test extensions (").append(configPrefix).append(".):\n\n");
        if (!setups.isEmpty()) {
            res.append("\tSetup objects = \n");
            TrackerReportBuilder.logTracks(res, setups);
        }
        if (!hooks.isEmpty()) {
            res.append("\tTest hooks = \n");
            TrackerReportBuilder.logTracks(res, hooks);
        }
        return res.toString();
    }

    public static String buildPerformanceReport(List<PerformanceTrack> tracks, ExtensionContext context, GuiceyTestTime phase) {
        StringBuilder res = new StringBuilder();
        Duration overall = Duration.ZERO;
        Duration increase = Duration.ZERO;
        for (PerformanceTrack root : tracks) {
            if (!root.isRoot()) continue;
            overall = overall.plus(root.getOverall());
            if (!root.isDurationChanged()) continue;
            increase = increase.plus(root.getIncrease());
            res.append("\n\t").append(root).append('\n');
            for (PerformanceTrack track : tracks) {
                if (track.isRoot() || track.phase != root.name || !root.isDurationChanged()) continue;
                res.append("\t\t").append(track).append('\n');
            }
        }
        tracks.forEach(PerformanceTrack::markLogged);
        Duration lastOverall = overall.minus(increase);
        String title = PrintUtils.getPerformanceReportSeparator(context) + "Guicey time after [" + phase.getDisplayName() + "] of " + TestSetupUtils.getContextTestName(context) + ": " + PrintUtils.renderTime(overall, lastOverall.equals(Duration.ZERO) ? null : increase);
        return title + "\n" + res;
    }

    public static String buildConfigsReport(String configPrefix, List<String> modifiers) {
        boolean hasOverrides;
        StringBuilder res = new StringBuilder(100);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(configPrefix)) continue;
            res.append(String.format("\t %20s = %s%n", key.substring(configPrefix.length() + 1), entry.getValue()));
        }
        boolean bl = hasOverrides = res.length() > 0;
        if (!modifiers.isEmpty()) {
            res.append("\nConfiguration modifiers:\n");
            TrackerReportBuilder.logTracks(res, modifiers);
        }
        return (String)(hasOverrides ? "\nConfiguration overrides (" + configPrefix + ".):\n" : "") + res;
    }

    private static void logTracks(StringBuilder res, List<String> tracks) {
        for (String st : tracks) {
            res.append("\t\t").append(st).append('\n');
        }
        res.append('\n');
    }
}

